/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.XaTransaction;
import org.mule.transport.ConnectException;
import org.mule.transport.SingleAttemptConnectionStrategy;
import org.mule.transport.TransactedPollingMessageReceiver;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.RedeliveryHandler;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.util.ClassUtils;
import org.mule.util.MapUtils;

public class XaTransactedJmsMessageReceiver
extends TransactedPollingMessageReceiver {
    public static final long DEFAULT_JMS_POLL_FREQUENCY = 100L;
    public static final TimeUnit DEFAULT_JMS_POLL_TIMEUNIT = TimeUnit.MILLISECONDS;
    protected final JmsConnector connector;
    protected boolean reuseConsumer;
    protected boolean reuseSession;
    protected final ThreadContextLocal context = new ThreadContextLocal();
    protected final long timeout;
    protected final RedeliveryHandler redeliveryHandler;

    public XaTransactedJmsMessageReceiver(Connector umoConnector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(umoConnector, service, endpoint);
        this.setFrequency(100L);
        this.setTimeUnit(DEFAULT_JMS_POLL_TIMEUNIT);
        this.connector = (JmsConnector)umoConnector;
        this.timeout = endpoint.getTransactionConfig().getTimeout();
        if (this.connectionStrategy instanceof SingleAttemptConnectionStrategy) {
            this.reuseConsumer = true;
            this.reuseSession = true;
        }
        this.reuseConsumer = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"reuseConsumer", (boolean)this.reuseConsumer);
        this.reuseSession = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"reuseSession", (boolean)this.reuseSession);
        boolean topic = this.connector.getTopicResolver().isTopic((ImmutableEndpoint)this.getEndpoint());
        if (topic && (this.reuseConsumer || this.reuseSession)) {
            this.logger.warn((Object)("Destination " + this.getEndpoint().getEndpointURI() + " is a topic and XA transaction was " + "configured. Forcing 'reuseSession' and 'reuseConsumer' to false. Set these " + "on endpoint to avoid the message."));
            this.reuseConsumer = false;
            this.reuseSession = false;
        }
        this.setUseMultipleTransactedReceivers(!topic);
        try {
            this.redeliveryHandler = this.connector.getRedeliveryHandlerFactory().create();
            this.redeliveryHandler.setConnector(this.connector);
        }
        catch (Exception e) {
            throw new CreateException((Throwable)e, (Object)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        if (this.connector.isConnected()) {
            this.closeResource(true);
        }
    }

    public void poll() throws Exception {
        TransactionTemplate tt = new TransactionTemplate(this.endpoint.getTransactionConfig(), this.connector.getExceptionListener(), this.connector.getMuleContext());
        TransactionCallback cb = new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                try {
                    List messages = XaTransactedJmsMessageReceiver.this.getMessages();
                    if (messages != null && messages.size() > 0) {
                        Iterator it = messages.iterator();
                        while (it.hasNext()) {
                            XaTransactedJmsMessageReceiver.this.processMessage(it.next());
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    JmsThreadContext ctx = XaTransactedJmsMessageReceiver.this.context.getContext();
                    ctx.consumer = null;
                    Transaction tx = TransactionCoordination.getInstance().getTransaction();
                    if (ctx.session != null && tx instanceof XaTransaction.MuleXaObject) {
                        ((XaTransaction.MuleXaObject)ctx.session).setReuseObject(false);
                    }
                    ctx.session = null;
                    throw e;
                }
            }
        };
        tt.execute(cb);
    }

    protected List getMessages() throws Exception {
        Message message;
        Transaction tx;
        Session session;
        block9: {
            session = this.connector.getSessionFromTransaction();
            tx = TransactionCoordination.getInstance().getTransaction();
            MessageConsumer consumer = this.createConsumer();
            message = null;
            try {
                message = consumer.receive(this.timeout);
            }
            catch (JMSException e) {
                if (!this.isConnected()) break block9;
                throw e;
            }
        }
        if (message == null) {
            if (tx != null) {
                tx.setRollbackOnly();
            }
            return null;
        }
        message = this.connector.preProcessMessage(message, session);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message received it is of type: " + ClassUtils.getSimpleName(message.getClass())));
            if (message.getJMSDestination() != null) {
                this.logger.debug((Object)("Message received on " + message.getJMSDestination() + " (" + message.getJMSDestination().getClass().getName() + ")"));
            } else {
                this.logger.debug((Object)"Message received on unknown destination");
            }
            this.logger.debug((Object)("Message CorrelationId is: " + message.getJMSCorrelationID()));
            this.logger.debug((Object)("Jms Message Id is: " + message.getJMSMessageID()));
        }
        if (message.getJMSRedelivered()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message with correlationId: " + message.getJMSCorrelationID() + " is redelivered. handing off to Exception Handler"));
            }
            this.redeliveryHandler.handleRedelivery(message);
        }
        MessageAdapter adapter = this.connector.getMessageAdapter(message);
        this.routeMessage((MuleMessage)new DefaultMuleMessage((Object)adapter));
        return null;
    }

    protected void processMessage(Object msg) throws Exception {
    }

    protected void closeResource(boolean force) {
        JmsThreadContext ctx = this.context.getContext();
        if (ctx == null) {
            return;
        }
        if (force || !this.reuseSession || !this.reuseConsumer) {
            this.connector.closeQuietly(ctx.consumer);
            ctx.consumer = null;
        }
        if (force || !this.reuseSession) {
            this.connector.closeQuietly(ctx.session);
            ctx.session = null;
        }
    }

    protected MessageConsumer createConsumer() throws Exception {
        this.logger.debug((Object)"Create a consumer for the jms destination");
        try {
            String durableName;
            Session session;
            JmsSupport jmsSupport = this.connector.getJmsSupport();
            JmsThreadContext ctx = this.context.getContext();
            if (ctx == null) {
                ctx = new JmsThreadContext();
            }
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            if (this.reuseSession && ctx.session != null) {
                session = ctx.session;
                tx.bindResource((Object)this.connector.getConnection(), (Object)session);
            } else {
                session = this.connector.getSession((ImmutableEndpoint)this.endpoint);
                if (tx != null) {
                    ((XaTransaction.MuleXaObject)session).setReuseObject(this.reuseSession);
                }
            }
            if (this.reuseSession) {
                ctx.session = session;
            }
            if (this.reuseConsumer && ctx.consumer != null) {
                return ctx.consumer;
            }
            boolean topic = this.connector.getTopicResolver().isTopic((ImmutableEndpoint)this.endpoint);
            Destination dest = jmsSupport.createDestination(session, this.endpoint.getEndpointURI().getAddress(), topic);
            String selector = null;
            if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                selector = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
            } else if (this.endpoint.getProperties() != null) {
                selector = (String)this.endpoint.getProperties().get("selector");
            }
            String tempDurable = (String)this.endpoint.getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && topic) {
                durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
            }
            MessageConsumer consumer = jmsSupport.createConsumer(session, dest, selector, this.connector.isNoLocal(), durableName, topic);
            if (this.reuseConsumer) {
                ctx.consumer = consumer;
            }
            return consumer;
        }
        catch (JMSException e) {
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
    }

    protected static class ThreadContextLocal
    extends ThreadLocal {
        protected ThreadContextLocal() {
        }

        public JmsThreadContext getContext() {
            return (JmsThreadContext)this.get();
        }

        protected Object initialValue() {
            return new JmsThreadContext();
        }
    }

    protected static class JmsThreadContext {
        public Session session;
        public MessageConsumer consumer;

        protected JmsThreadContext() {
        }
    }
}

