/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import com.mockobjects.dynamic.AnyConstraintMatcher;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.MessageFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.AbstractMessageReceiverTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsConnectorTestCase;
import org.mule.transport.jms.JmsMessageReceiver;

public class JmsMessageReceiverTestCase
extends AbstractMessageReceiverTestCase {
    private JmsConnector connector;

    protected void doSetUp() throws Exception {
        this.connector = new JmsConnector();
        this.connector.setName("TestConnector");
        this.connector.setSpecification("1.1");
        Mock connectionFactory = new Mock(ConnectionFactory.class);
        Mock connection = new Mock(Connection.class);
        connectionFactory.expectAndReturn("createConnection", connection.proxy());
        connection.expect("setExceptionListener", (ConstraintMatcher)new AnyConstraintMatcher());
        connection.expect("close");
        connection.expect("start");
        connection.expect("stop");
        this.connector.setConnectionFactory((ConnectionFactory)connectionFactory.proxy());
        this.connector.setMuleContext(muleContext);
        muleContext.getRegistry().registerConnector((Connector)this.connector);
        super.doSetUp();
    }

    public void testReceive() throws Exception {
        JmsMessageReceiver receiver = (JmsMessageReceiver)this.getMessageReceiver();
        JmsMessageReceiverTestCase.assertNotNull((Object)receiver.getService());
        JmsMessageReceiverTestCase.assertNotNull((Object)receiver.getConnector());
        JmsMessageReceiverTestCase.assertNotNull((Object)receiver.getEndpoint());
    }

    public MessageReceiver getMessageReceiver() throws Exception {
        return new JmsMessageReceiver(this.endpoint.getConnector(), JmsMessageReceiverTestCase.getTestService((String)"orange", Orange.class), this.endpoint);
    }

    public Object getValidMessage() throws Exception {
        return JmsConnectorTestCase.getMessage();
    }

    public InboundEndpoint getEndpoint() throws Exception {
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("jms://testcase", muleContext);
        if (this.connector == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Connector has not been initialized."), null);
        }
        builder.setConnector((Connector)this.connector);
        this.endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
        return this.endpoint;
    }
}

