/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.config;

import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.transaction.XaTransactionFactory;
import org.mule.transport.jms.DefaultRedeliveryHandler;
import org.mule.transport.jms.DefaultRedeliveryHandlerFactory;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.filters.JmsPropertyFilter;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.transport.jms.test.TestConnectionFactory;
import org.mule.transport.jms.test.TestRedeliveryHandler;

public class JmsNamespaceHandlerTestCase
extends FunctionalTestCase {
    public JmsNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigResources() {
        return "jms-namespace-config.xml";
    }

    public void testDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnectorDefaults");
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getConnectionFactory() instanceof TestConnectionFactory));
        JmsNamespaceHandlerTestCase.assertEquals((int)1, (int)c.getAcknowledgementMode());
        JmsNamespaceHandlerTestCase.assertNull((Object)c.getUsername());
        JmsNamespaceHandlerTestCase.assertNull((Object)c.getPassword());
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getRedeliveryHandlerFactory() instanceof DefaultRedeliveryHandlerFactory));
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof DefaultRedeliveryHandler));
        JmsNamespaceHandlerTestCase.assertNull((Object)c.getClientId());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isDurable());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isNoLocal());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isPersistentDelivery());
        JmsNamespaceHandlerTestCase.assertEquals((int)0, (int)c.getMaxRedelivery());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isCacheJmsSessions());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isRecoverJmsConnections());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isEagerConsumer());
    }

    public void testConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector1");
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getConnectionFactory() instanceof TestConnectionFactory));
        JmsNamespaceHandlerTestCase.assertEquals((int)3, (int)c.getAcknowledgementMode());
        JmsNamespaceHandlerTestCase.assertEquals((String)"myuser", (String)c.getUsername());
        JmsNamespaceHandlerTestCase.assertEquals((String)"mypass", (String)c.getPassword());
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof TestRedeliveryHandler));
        JmsNamespaceHandlerTestCase.assertEquals((String)"myClient", (String)c.getClientId());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isDurable());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isNoLocal());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isPersistentDelivery());
        JmsNamespaceHandlerTestCase.assertEquals((int)5, (int)c.getMaxRedelivery());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isCacheJmsSessions());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isRecoverJmsConnections());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isEagerConsumer());
        JmsNamespaceHandlerTestCase.assertEquals((String)"1.1", (String)c.getSpecification());
        JmsNamespaceHandlerTestCase.assertEquals((int)c.getNumberOfConcurrentTransactedReceivers(), (int)7);
    }

    public void testCustomConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector2");
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsNamespaceHandlerTestCase.assertEquals((String)"1.1", (String)c.getSpecification());
    }

    public void testTestConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector3");
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getConnectionFactory() instanceof TestConnectionFactory));
        JmsNamespaceHandlerTestCase.assertEquals((int)3, (int)c.getAcknowledgementMode());
        JmsNamespaceHandlerTestCase.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof TestRedeliveryHandler));
        JmsNamespaceHandlerTestCase.assertEquals((String)"myClient", (String)c.getClientId());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isDurable());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isNoLocal());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isPersistentDelivery());
        JmsNamespaceHandlerTestCase.assertEquals((int)5, (int)c.getMaxRedelivery());
        JmsNamespaceHandlerTestCase.assertTrue((boolean)c.isCacheJmsSessions());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isRecoverJmsConnections());
        JmsNamespaceHandlerTestCase.assertFalse((boolean)c.isEagerConsumer());
        JmsNamespaceHandlerTestCase.assertEquals((String)"1.1", (String)c.getSpecification());
    }

    public void testEndpointConfig() throws EndpointException, InitialisationException {
        InboundEndpoint endpoint1 = muleContext.getRegistry().lookupEndpointBuilder("endpoint1").buildInboundEndpoint();
        JmsNamespaceHandlerTestCase.assertNotNull((Object)endpoint1);
        Filter filter1 = endpoint1.getFilter();
        JmsNamespaceHandlerTestCase.assertNotNull((Object)filter1);
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(filter1 instanceof JmsSelectorFilter));
        OutboundEndpoint endpoint2 = muleContext.getRegistry().lookupEndpointBuilder("endpoint2").buildOutboundEndpoint();
        JmsNamespaceHandlerTestCase.assertNotNull((Object)endpoint2);
        Filter filter2 = endpoint2.getFilter();
        JmsNamespaceHandlerTestCase.assertNotNull((Object)filter2);
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(filter2 instanceof NotFilter));
        Filter filter3 = ((NotFilter)filter2).getFilter();
        JmsNamespaceHandlerTestCase.assertNotNull((Object)filter3);
        JmsNamespaceHandlerTestCase.assertTrue((boolean)(filter3 instanceof JmsPropertyFilter));
    }

    public void testCustomTransactions() throws EndpointException, InitialisationException {
        InboundEndpoint endpoint3 = muleContext.getRegistry().lookupEndpointBuilder("endpoint3").buildInboundEndpoint();
        JmsNamespaceHandlerTestCase.assertNotNull((Object)endpoint3);
        TestTransactionFactory factory = (TestTransactionFactory)endpoint3.getTransactionConfig().getFactory();
        JmsNamespaceHandlerTestCase.assertNotNull((Object)factory);
        JmsNamespaceHandlerTestCase.assertEquals((String)"foo", (String)factory.getValue());
    }

    public void testXaTransactions() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointBuilder("endpoint4").buildInboundEndpoint();
        JmsNamespaceHandlerTestCase.assertNotNull((Object)endpoint);
        JmsNamespaceHandlerTestCase.assertEquals(XaTransactionFactory.class, endpoint.getTransactionConfig().getFactory().getClass());
        JmsNamespaceHandlerTestCase.assertEquals((byte)3, (byte)endpoint.getTransactionConfig().getAction());
    }
}

