/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import junit.framework.Assert;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

public abstract class AbstractJmsFunctionalTestCase
extends FunctionalTestCase {
    public static final String DEFAULT_BROKER_URL = "vm://localhost?broker.persistent=false&broker.useJmx=false";
    public static final String DEFAULT_INPUT_MESSAGE = "INPUT MESSAGE";
    public static final String DEFAULT_OUTPUT_MESSAGE = "OUTPUT MESSAGE";
    public static final String DEFAULT_INPUT_MQ_QUEUE_NAME = "in";
    public static final String DEFAULT_INPUT_MULE_QUEUE_NAME = "jms://in";
    public static final String DEFAULT_OUTPUT_MQ_QUEUE_NAME = "out";
    public static final String DEFAULT_OUTPUT_MULE_QUEUE_NAME = "jms://out";
    public static final long TIMEOUT = 5000L;
    public static final long SMALL_TIMEOUT = 1000L;
    public static final long LOCK_WAIT = 1000L;
    public static final String CONNECTOR_NAME = "MuleMQConnector";
    private MuleClient client;
    protected Scenario scenarioNoTx = new NonTransactedScenario();
    protected Scenario scenarioCommit = new ScenarioCommit();
    protected Scenario scenarioRollback = new ScenarioRollback();
    protected Scenario scenarioNotReceive = new ScenarioNotReceive();

    protected void dispatchMessage() throws Exception {
        this.client.dispatch(DEFAULT_INPUT_MULE_QUEUE_NAME, (Object)DEFAULT_INPUT_MESSAGE, null);
    }

    protected void dispatchMessage(Object payload) throws Exception {
        this.client.dispatch(DEFAULT_INPUT_MULE_QUEUE_NAME, payload, null);
    }

    protected MuleMessage receiveMessage() throws Exception {
        MuleMessage result = this.client.request(DEFAULT_OUTPUT_MULE_QUEUE_NAME, 5000L);
        AbstractJmsFunctionalTestCase.assertNotNull((Object)result);
        AbstractJmsFunctionalTestCase.assertNotNull((Object)result.getPayload());
        AbstractJmsFunctionalTestCase.assertNull((Object)result.getExceptionPayload());
        AbstractJmsFunctionalTestCase.assertEquals((Object)DEFAULT_OUTPUT_MESSAGE, (Object)result.getPayload());
        return result;
    }

    public void runAsynchronousDispatching() throws Exception {
        this.dispatchMessage();
        this.receiveMessage();
        MuleMessage result = this.client.request(DEFAULT_OUTPUT_MULE_QUEUE_NAME, 1000L);
        AbstractJmsFunctionalTestCase.assertNull((Object)result);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client = new MuleClient();
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.client.dispose();
    }

    protected MuleClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Scenario scenario) throws Exception {
        Connection connection = null;
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(scenario.getBrokerUrl());
            connection = factory.createConnection();
            connection.start();
            Session session = null;
            try {
                session = connection.createSession(scenario.isTransacted(), scenario.getAcknowledge());
                ActiveMQQueue destination = new ActiveMQQueue(scenario.getInputQueue());
                MessageProducer producer = null;
                try {
                    producer = session.createProducer((Destination)destination);
                    scenario.send(session, producer);
                }
                finally {
                    if (producer != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Message receive(Scenario scenario) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    class ScenarioNotReceive
    extends NonTransactedScenario {
        ScenarioNotReceive() {
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(1000L);
            Assert.assertNull((Object)message);
            return message;
        }
    }

    class ScenarioRollback
    extends AbstractScenario {
        ScenarioRollback() {
        }

        public boolean isTransacted() {
            return true;
        }

        protected void applyTransaction(Session session) throws JMSException {
            session.rollback();
        }
    }

    class ScenarioCommit
    extends AbstractScenario {
        ScenarioCommit() {
        }

        public boolean isTransacted() {
            return true;
        }

        protected void applyTransaction(Session session) throws JMSException {
            session.commit();
        }
    }

    class NonTransactedScenario
    extends AbstractScenario {
        NonTransactedScenario() {
        }

        public boolean isTransacted() {
            return false;
        }

        protected void applyTransaction(Session session) throws JMSException {
        }
    }

    abstract class AbstractScenario
    implements Scenario {
        private String inputQueue = "in";
        private String outputQueue = "out";

        AbstractScenario() {
        }

        public String getBrokerUrl() {
            return AbstractJmsFunctionalTestCase.DEFAULT_BROKER_URL;
        }

        public String getInputQueue() {
            return this.inputQueue;
        }

        public String getOutputQueue() {
            return this.outputQueue;
        }

        public void setInputQueue(String inputQueue) {
            this.inputQueue = inputQueue;
        }

        public void setOutputQueue(String outputQueue) {
            this.outputQueue = outputQueue;
        }

        public int getAcknowledge() {
            return 1;
        }

        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage(AbstractJmsFunctionalTestCase.DEFAULT_INPUT_MESSAGE));
            this.applyTransaction(session);
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((String)AbstractJmsFunctionalTestCase.DEFAULT_OUTPUT_MESSAGE, (String)((TextMessage)message).getText());
            this.applyTransaction(session);
            return message;
        }

        protected abstract void applyTransaction(Session var1) throws JMSException;
    }

    static interface Scenario {
        public String getBrokerUrl();

        public String getInputQueue();

        public void setInputQueue(String var1);

        public String getOutputQueue();

        public void setOutputQueue(String var1);

        public int getAcknowledge();

        public void send(Session var1, MessageProducer var2) throws JMSException, SystemException, HeuristicMixedException, HeuristicRollbackException, RollbackException;

        public Message receive(Session var1, MessageConsumer var2) throws JMSException, SystemException, HeuristicMixedException, HeuristicRollbackException, RollbackException;

        public boolean isTransacted();
    }
}

