/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.mule.api.MessagingException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.jms.JmsMessageUtils;

public class JmsMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -8151716840620558143L;
    private String jmsSpec;
    private Message jmsMessage;

    public JmsMessageAdapter(Object message) throws MessagingException {
        this.setMessage(message);
    }

    protected JmsMessageAdapter(JmsMessageAdapter template) {
        super((MessageAdapter)template);
        this.jmsSpec = template.jmsSpec;
        this.jmsMessage = template.jmsMessage;
    }

    public void setSpecification(String newSpec) {
        if (!"1.1".equals(newSpec) && !"1.0.2b".equals(newSpec)) {
            throw new IllegalArgumentException("JMS specification needs to be one of the defined values in JmsConstants but was: " + newSpec);
        }
        this.jmsSpec = newSpec;
    }

    public String getPayloadAsString(String encoding) throws Exception {
        return new String(this.getPayloadAsBytes(), encoding);
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return JmsMessageUtils.toByteArray(this.jmsMessage, this.jmsSpec);
    }

    public Object getPayload() {
        return this.jmsMessage;
    }

    private void setMessage(Object message) throws MessagingException {
        if (!(message instanceof Message)) {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
        this.jmsMessage = (Message)message;
        try {
            String value = this.jmsMessage.getJMSCorrelationID();
            if (value != null) {
                this.setProperty("JMSCorrelationID", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            int value = this.jmsMessage.getJMSDeliveryMode();
            this.setProperty("JMSDeliveryMode", new Integer(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Destination value = this.jmsMessage.getJMSDestination();
            if (value != null) {
                this.setProperty("JMSDestination", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            long value = this.jmsMessage.getJMSExpiration();
            this.setProperty("JMSExpiration", new Long(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            String value = this.jmsMessage.getJMSMessageID();
            if (value != null) {
                this.setProperty("JMSMessageID", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            int value = this.jmsMessage.getJMSPriority();
            this.setProperty("JMSPriority", new Integer(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            boolean value = this.jmsMessage.getJMSRedelivered();
            this.setProperty("JMSRedelivered", value);
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Destination value = this.jmsMessage.getJMSReplyTo();
            if (value != null) {
                this.setProperty("JMSReplyTo", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            long value = this.jmsMessage.getJMSTimestamp();
            this.setProperty("JMSTimestamp", new Long(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            String value = this.jmsMessage.getJMSType();
            if (value != null) {
                this.setProperty("JMSType", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Enumeration e = this.jmsMessage.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                try {
                    Object value = this.jmsMessage.getObjectProperty(key);
                    if (value == null) continue;
                    this.setProperty(key, value);
                }
                catch (JMSException e1) {}
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public String getUniqueId() {
        return (String)this.getProperty("JMSMessageID");
    }

    public void setCorrelationId(String id) {
        this.setProperty("JMSCorrelationID", id);
    }

    public String getCorrelationId() {
        return (String)this.getProperty("JMSCorrelationID");
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo instanceof Destination) {
            this.setProperty("JMSReplyTo", replyTo);
        } else {
            super.setReplyTo(replyTo);
        }
    }

    public Object getReplyTo() {
        Object replyTo = this.getProperty("JMSReplyTo");
        if (replyTo == null) {
            replyTo = this.getProperty("MULE_REPLYTO");
        }
        return replyTo;
    }

    public ThreadSafeAccess newThreadCopy() {
        return new JmsMessageAdapter(this);
    }
}

