/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.apache.commons.lang.BooleanUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageAdapter;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsMessageUtils;
import org.mule.transport.jms.i18n.JmsMessages;
import org.mule.util.ClassUtils;
import org.mule.util.NumberUtils;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.Latch;
import org.mule.util.concurrent.WaitableBoolean;

public class JmsMessageDispatcher
extends AbstractMessageDispatcher {
    private JmsConnector connector;
    private Session cachedSession;

    public JmsMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (JmsConnector)endpoint.getConnector();
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        this.dispatchMessage(event);
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MuleMessage dispatchMessage(MuleEvent event) throws Exception {
        boolean cached;
        boolean transacted;
        Destination replyTo;
        MessageConsumer consumer;
        MessageProducer producer;
        Session session;
        block62: {
            Message result;
            block63: {
                boolean persistent;
                int priority;
                long ttl;
                Message msg;
                boolean topic;
                block60: {
                    Message result2;
                    block61: {
                        MuleMessage muleMessage;
                        session = null;
                        producer = null;
                        consumer = null;
                        replyTo = null;
                        transacted = false;
                        cached = false;
                        boolean remoteSync = this.useRemoteSync(event);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("dispatching on endpoint: " + event.getEndpoint().getEndpointURI() + ". MuleEvent id is: " + event.getId() + ". Outbound transformers are: " + event.getEndpoint().getTransformers()));
                        }
                        try {
                            session = this.connector.getSessionFromTransaction();
                            if (session != null) {
                                transacted = true;
                                if (remoteSync) {
                                    throw new IllegalTransactionStateException(JmsMessages.connectorDoesNotSupportSyncReceiveWhenTransacted());
                                }
                            } else if (event.getMessage().getBooleanProperty("cacheJmsSessions", this.connector.isCacheJmsSessions())) {
                                cached = true;
                                if (this.cachedSession != null) {
                                    session = this.cachedSession;
                                } else {
                                    this.cachedSession = session = this.connector.getSession(event.getEndpoint());
                                }
                            } else {
                                session = this.connector.getSession(event.getEndpoint());
                                if (event.getEndpoint().getTransactionConfig().isTransacted()) {
                                    transacted = true;
                                }
                            }
                            EndpointURI endpointUri = event.getEndpoint().getEndpointURI();
                            topic = this.connector.getTopicResolver().isTopic(event.getEndpoint(), true);
                            Destination dest = this.connector.getJmsSupport().createDestination(session, endpointUri.getAddress(), topic);
                            producer = this.connector.getJmsSupport().createProducer(session, dest, topic);
                            Object message = event.transformMessage();
                            if (!(message instanceof Message)) {
                                throw new DispatchException(JmsMessages.checkTransformer("JMS message", message.getClass(), this.connector.getName()), event.getMessage(), event.getEndpoint());
                            }
                            msg = (Message)message;
                            if (event.getMessage().getCorrelationId() != null) {
                                msg.setJMSCorrelationID(event.getMessage().getCorrelationId());
                            }
                            MuleMessage eventMsg = event.getMessage();
                            if (this.connector.supportsProperty("JMSReplyTo")) {
                                Object tempReplyTo = eventMsg.removeProperty("JMSReplyTo");
                                if (tempReplyTo == null && (tempReplyTo = eventMsg.removeProperty("MULE_REPLYTO")) != null) {
                                    if (tempReplyTo.toString().startsWith("jms://")) {
                                        tempReplyTo = tempReplyTo.toString().substring(6);
                                    } else {
                                        EndpointBuilder epb = event.getMuleContext().getRegistry().lookupEndpointBuilder(tempReplyTo.toString());
                                        if (epb != null) {
                                            tempReplyTo = epb.buildOutboundEndpoint().getEndpointURI().getAddress();
                                        }
                                    }
                                }
                                if (tempReplyTo != null) {
                                    if (tempReplyTo instanceof Destination) {
                                        replyTo = (Destination)tempReplyTo;
                                    } else {
                                        boolean replyToTopic = false;
                                        String reply = tempReplyTo.toString();
                                        int i = reply.indexOf(":");
                                        if (i > -1) {
                                            String qtype = reply.substring(0, i);
                                            replyToTopic = "topic".equalsIgnoreCase(qtype);
                                            reply = reply.substring(i + 1);
                                        }
                                        replyTo = this.connector.getJmsSupport().createDestination(session, reply, replyToTopic);
                                    }
                                }
                                if (remoteSync && replyTo == null) {
                                    replyTo = this.connector.getJmsSupport().createTemporaryDestination(session, topic);
                                }
                                if (replyTo != null) {
                                    msg.setJMSReplyTo(replyTo);
                                }
                                if (remoteSync) {
                                    try {
                                        consumer = this.connector.getJmsSupport().createConsumer(session, replyTo, topic);
                                    }
                                    catch (Exception e) {
                                        this.logger.warn((Object)e);
                                    }
                                }
                            }
                            String ttlString = (String)eventMsg.removeProperty("timeToLive");
                            String priorityString = (String)eventMsg.removeProperty("priority");
                            String persistentDeliveryString = (String)eventMsg.removeProperty("persistentDelivery");
                            ttl = StringUtils.isNotBlank((String)ttlString) ? NumberUtils.toLong((String)ttlString) : 0L;
                            priority = StringUtils.isNotBlank((String)priorityString) ? NumberUtils.toInt((String)priorityString) : 4;
                            boolean bl = persistent = StringUtils.isNotBlank((String)persistentDeliveryString) ? BooleanUtils.toBoolean((String)persistentDeliveryString) : this.connector.isPersistentDelivery();
                            if (this.connector.isHonorQosHeaders()) {
                                int priorityProp = eventMsg.getIntProperty("JMSPriority", -1);
                                int deliveryModeProp = eventMsg.getIntProperty("JMSDeliveryMode", -1);
                                if (priorityProp != -1) {
                                    priority = priorityProp;
                                }
                                if (deliveryModeProp != -1) {
                                    boolean bl2 = persistent = deliveryModeProp == 2;
                                }
                            }
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Sending message of type " + ClassUtils.getSimpleName(msg.getClass())));
                            }
                            if (consumer == null || !topic) break block60;
                            Latch l = new Latch();
                            ReplyToListener listener = new ReplyToListener(l);
                            consumer.setMessageListener((MessageListener)listener);
                            this.connector.getJmsSupport().send(producer, msg, persistent, priority, ttl, topic);
                            int timeout2 = event.getTimeout();
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Waiting for return event for: " + timeout2 + " ms on " + replyTo));
                            }
                            l.await((long)timeout2, TimeUnit.MILLISECONDS);
                            consumer.setMessageListener(null);
                            listener.release();
                            result2 = listener.getMessage();
                            if (result2 != null) break block61;
                            this.logger.debug((Object)"No message was returned via replyTo destination");
                            muleMessage = null;
                            Object var29_38 = null;
                            this.connector.closeQuietly(producer);
                            this.connector.closeQuietly(consumer);
                        }
                        catch (Throwable throwable) {
                            block64: {
                                Object var29_43 = null;
                                this.connector.closeQuietly(producer);
                                this.connector.closeQuietly(consumer);
                                if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                                    if (replyTo instanceof TemporaryQueue) {
                                        this.connector.closeQuietly((TemporaryQueue)replyTo);
                                    } else {
                                        this.connector.closeQuietly((TemporaryTopic)replyTo);
                                    }
                                }
                                if (session == null || cached || transacted) break block64;
                                this.connector.closeQuietly(session);
                            }
                            throw throwable;
                        }
                        if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                            if (replyTo instanceof TemporaryQueue) {
                                this.connector.closeQuietly((TemporaryQueue)replyTo);
                            } else {
                                this.connector.closeQuietly((TemporaryTopic)replyTo);
                            }
                        }
                        if (session != null && !cached && !transacted) {
                            this.connector.closeQuietly(session);
                        }
                        return muleMessage;
                    }
                    MessageAdapter adapter = this.connector.getMessageAdapter(result2);
                    DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage(JmsMessageUtils.toObject(result2, this.connector.getSpecification()), adapter);
                    Object var29_39 = null;
                    this.connector.closeQuietly(producer);
                    this.connector.closeQuietly(consumer);
                    if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                        if (replyTo instanceof TemporaryQueue) {
                            this.connector.closeQuietly((TemporaryQueue)replyTo);
                        } else {
                            this.connector.closeQuietly((TemporaryTopic)replyTo);
                        }
                    }
                    if (session != null && !cached && !transacted) {
                        this.connector.closeQuietly(session);
                    }
                    return defaultMuleMessage;
                }
                this.connector.getJmsSupport().send(producer, msg, persistent, priority, ttl, topic);
                if (consumer == null) break block62;
                int timeout = event.getTimeout();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Waiting for return event for: " + timeout + " ms on " + replyTo));
                }
                if ((result = consumer.receive((long)timeout)) != null) break block63;
                this.logger.debug((Object)"No message was returned via replyTo destination");
                MuleMessage timeout2 = null;
                Object var29_40 = null;
                this.connector.closeQuietly(producer);
                this.connector.closeQuietly(consumer);
                if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                    if (replyTo instanceof TemporaryQueue) {
                        this.connector.closeQuietly((TemporaryQueue)replyTo);
                    } else {
                        this.connector.closeQuietly((TemporaryTopic)replyTo);
                    }
                }
                if (session != null && !cached && !transacted) {
                    this.connector.closeQuietly(session);
                }
                return timeout2;
            }
            MessageAdapter adapter = this.connector.getMessageAdapter(result);
            DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage(JmsMessageUtils.toObject(result, this.connector.getSpecification()), adapter);
            Object var29_41 = null;
            this.connector.closeQuietly(producer);
            this.connector.closeQuietly(consumer);
            if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                if (replyTo instanceof TemporaryQueue) {
                    this.connector.closeQuietly((TemporaryQueue)replyTo);
                } else {
                    this.connector.closeQuietly((TemporaryTopic)replyTo);
                }
            }
            if (session != null && !cached && !transacted) {
                this.connector.closeQuietly(session);
            }
            return defaultMuleMessage;
        }
        MuleMessage muleMessage = null;
        Object var29_42 = null;
        this.connector.closeQuietly(producer);
        this.connector.closeQuietly(consumer);
        if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
            if (replyTo instanceof TemporaryQueue) {
                this.connector.closeQuietly((TemporaryQueue)replyTo);
            } else {
                this.connector.closeQuietly((TemporaryTopic)replyTo);
            }
        }
        if (session != null && !cached && !transacted) {
            this.connector.closeQuietly(session);
        }
        return muleMessage;
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        MuleMessage message = this.dispatchMessage(event);
        return message;
    }

    protected void doDispose() {
    }

    private class ReplyToListener
    implements MessageListener {
        private final Latch latch;
        private volatile Message message;
        private final WaitableBoolean released = new WaitableBoolean(false);

        public ReplyToListener(Latch latch) {
            this.latch = latch;
        }

        public Message getMessage() {
            return this.message;
        }

        public void release() {
            this.released.set(true);
        }

        public void onMessage(Message message) {
            this.message = message;
            this.latch.countDown();
            try {
                this.released.whenTrue(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

