/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.filters.JmsSelectorFilter;

public class JmsMessageRequester
extends AbstractMessageRequester {
    private JmsConnector connector;

    public JmsMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (JmsConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MuleMessage doRequest(long timeout) throws Exception {
        Session session = null;
        MessageConsumer consumer = null;
        try {
            Message message;
            block11: {
                MuleMessage muleMessage;
                String durableName;
                boolean topic = this.connector.getTopicResolver().isTopic(this.endpoint);
                JmsSupport support = this.connector.getJmsSupport();
                session = this.connector.getSession(false, topic);
                Destination dest = support.createDestination(session, this.endpoint.getEndpointURI().getAddress(), topic);
                String selector = null;
                if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                    selector = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
                } else if (this.endpoint.getProperties() != null) {
                    selector = (String)this.endpoint.getProperties().get("selector");
                }
                String tempDurable = (String)this.endpoint.getProperties().get("durable");
                boolean durable = this.connector.isDurable();
                if (tempDurable != null) {
                    durable = Boolean.valueOf(tempDurable);
                }
                if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && topic) {
                    durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
                    }
                }
                consumer = support.createConsumer(session, dest, selector, this.connector.isNoLocal(), durableName, topic);
                try {
                    message = timeout == -1L ? consumer.receiveNoWait() : (timeout == 0L ? consumer.receive() : consumer.receive(timeout));
                    if (message != null) break block11;
                    muleMessage = null;
                }
                catch (Exception e) {
                    this.connector.handleException(e);
                    MuleMessage muleMessage2 = null;
                    Object var15_18 = null;
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    return muleMessage2;
                }
                Object var15_16 = null;
                this.connector.closeQuietly(consumer);
                this.connector.closeQuietly(session);
                return muleMessage;
            }
            message = this.connector.preProcessMessage(message, session);
            DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage((Object)this.connector.getMessageAdapter(message));
            Object var15_17 = null;
            this.connector.closeQuietly(consumer);
            this.connector.closeQuietly(session);
            return defaultMuleMessage;
        }
        catch (Throwable throwable2) {
            Object var15_19 = null;
            this.connector.closeQuietly(consumer);
            this.connector.closeQuietly(session);
            throw throwable2;
        }
    }

    protected void doDispose() {
    }
}

