/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.filters;

import java.util.regex.Pattern;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class JmsPropertyFilter
implements Filter {
    private static Log logger = LogFactory.getLog(JmsPropertyFilter.class);
    private String propertyName = null;
    private String propertyClass = null;
    private String expression = null;
    private Pattern pattern = null;

    public boolean accept(MuleMessage message) {
        if (StringUtils.isBlank((String)this.propertyName)) {
            logger.warn((Object)"No property name was specified");
            return false;
        }
        if (StringUtils.isBlank((String)this.expression) && this.pattern == null) {
            logger.warn((Object)"Either no expression or pattern was specified");
            return false;
        }
        if (message.getPayload() instanceof Message) {
            try {
                Message m = (Message)message.getPayload();
                if (StringUtils.isBlank((String)this.propertyClass)) {
                    Object object = m.getObjectProperty(this.propertyName);
                    if (object == null) {
                        return false;
                    }
                    String value = object.toString();
                    if (this.pattern != null) {
                        return this.pattern.matcher(value).find();
                    }
                    return value.equals(this.expression);
                }
                if (this.propertyClass.equals("java.lang.String")) {
                    String value = m.getStringProperty(this.propertyName);
                    if (value == null) {
                        return false;
                    }
                    if (this.pattern != null) {
                        return this.pattern.matcher(value).find();
                    }
                    return value.equals(this.expression);
                }
                if (this.propertyClass.equals("java.lang.Integer")) {
                    int match;
                    int value = m.getIntProperty(this.propertyName);
                    return value == (match = Integer.parseInt(this.expression));
                }
                if (this.propertyClass.equals("java.lang.Short")) {
                    short match;
                    short value = m.getShortProperty(this.propertyName);
                    return value == (match = Short.parseShort(this.expression));
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)("Unable to convert expression " + this.expression + " to " + this.propertyClass + ": " + nfe.toString()));
            }
            catch (Exception e) {
                logger.warn((Object)("Error filtering on property " + this.propertyName + ": " + e.toString()));
            }
        } else {
            logger.warn((Object)("Expected a payload of javax.jms.Message but instead received " + ClassUtils.getSimpleName(message.getPayload().getClass())));
        }
        return false;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyClass(String propertyClass) {
        this.propertyClass = propertyClass;
    }

    public String getPropertyClass() {
        return this.propertyClass;
    }

    public String getPattern() {
        return this.pattern == null ? null : this.pattern.pattern();
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }
}

