/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.mule.api.DefaultMuleException;
import org.mule.api.config.ExceptionReader;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.jms.JmsExceptionReader;

public class JmsExceptionReaderTestCase
extends AbstractMuleTestCase {
    protected void doSetUp() throws Exception {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new JmsExceptionReader());
    }

    public void testNestedExceptionRetrieval() throws Exception {
        Exception testException = this.getException();
        Throwable t = ExceptionHelper.getRootException((Throwable)testException);
        JmsExceptionReaderTestCase.assertNotNull((Object)t);
        JmsExceptionReaderTestCase.assertEquals((String)"blah", (String)t.getMessage());
        JmsExceptionReaderTestCase.assertNull((Object)t.getCause());
        t = ExceptionHelper.getRootMuleException((Throwable)testException);
        JmsExceptionReaderTestCase.assertNotNull((Object)t);
        JmsExceptionReaderTestCase.assertEquals((String)"bar", (String)t.getMessage());
        JmsExceptionReaderTestCase.assertNotNull((Object)t.getCause());
        List l = ExceptionHelper.getExceptionsAsList((Throwable)testException);
        JmsExceptionReaderTestCase.assertEquals((int)4, (int)l.size());
        Map info = ExceptionHelper.getExceptionInfo((Throwable)testException);
        JmsExceptionReaderTestCase.assertNotNull((Object)info);
        JmsExceptionReaderTestCase.assertEquals((int)2, (int)info.size());
        JmsExceptionReaderTestCase.assertNotNull(info.get("JavaDoc"));
        JmsExceptionReaderTestCase.assertEquals((Object)"1234", info.get("JMS Code"));
    }

    private Exception getException() {
        JMSException e = new JMSException("Jms error", "1234");
        e.setLinkedException((Exception)new IOException("blah"));
        return new DefaultMuleException(MessageFactory.createStaticMessage((String)"foo"), (Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)"bar"), (Throwable)e));
    }
}

