/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.mule.tck.FunctionalTestCase;

public class JmsSingleTransactionRecieveAndSendTestCase
extends FunctionalTestCase {
    private Connection connection = null;
    private Session session = null;

    protected String getConfigResources() {
        return "providers/activemq/jms-single-tx-recieve-send-in-one-tx.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleTransactionBeginOrJoinAndAlwaysBegin() throws Exception {
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
            this.connection = factory.createConnection();
            this.connection.start();
            try {
                this.session = this.connection.createSession(true, 1);
                ActiveMQQueue destination = new ActiveMQQueue("in");
                MessageProducer producer = null;
                try {
                    producer = this.session.createProducer((Destination)destination);
                    producer.send((Message)this.session.createTextMessage("INPUT MESSAGE"));
                    this.session.commit();
                }
                finally {
                    if (producer != null) {
                        producer.close();
                    }
                }
                destination = new ActiveMQQueue("out");
                MessageConsumer consumer = null;
                try {
                    consumer = this.session.createConsumer((Destination)destination);
                    Message message = consumer.receive(5000L);
                    JmsSingleTransactionRecieveAndSendTestCase.assertNotNull((Object)message);
                    JmsSingleTransactionRecieveAndSendTestCase.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
                    JmsSingleTransactionRecieveAndSendTestCase.assertEquals((String)((TextMessage)message).getText(), (String)"OUTPUT MESSAGE");
                    this.session.commit();
                }
                finally {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
            }
            finally {
                if (this.session != null) {
                    this.session.close();
                }
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }
}

