/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.vendors;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.jms.DefaultJmsTopicResolver;
import org.mule.transport.jms.DefaultRedeliveryHandler;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.activemq.ActiveMQJmsConnector;
import org.mule.transport.jms.test.TestRedeliveryHandler;

public class ActiveMQJmsConnectorTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "activemq-config.xml";
    }

    public void testConfigurationDefaults() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        ActiveMQJmsConnectorTestCase.assertNotNull((Object)c);
        ActiveMQJmsConnectorTestCase.assertFalse((boolean)c.isEagerConsumer());
        ConnectionFactory cf = c.getConnectionFactory();
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)(cf instanceof ActiveMQConnectionFactory));
        ActiveMQJmsConnectorTestCase.assertEquals((String)"vm://localhost?broker.persistent=false&broker.useJmx=false", (String)((ActiveMQConnectionFactory)cf).getBrokerURL());
        ActiveMQJmsConnectorTestCase.assertNotNull((Object)c.getTopicResolver());
        ActiveMQJmsConnectorTestCase.assertTrue((String)"Wrong topic resolver configured on the connector.", (boolean)(c.getTopicResolver() instanceof DefaultJmsTopicResolver));
    }

    public void testDefaultActiveMqConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("activeMqJmsConnector");
        ActiveMQJmsConnectorTestCase.assertNotNull((Object)c);
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        ActiveMQJmsConnectorTestCase.assertNotNull((Object)c.getConnectionFactory());
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)(c.getConnectionFactory() instanceof ActiveMQConnectionFactory));
        ActiveMQJmsConnectorTestCase.assertEquals((int)1, (int)c.getAcknowledgementMode());
        ActiveMQJmsConnectorTestCase.assertNull((Object)c.getUsername());
        ActiveMQJmsConnectorTestCase.assertNull((Object)c.getPassword());
        ActiveMQJmsConnectorTestCase.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof DefaultRedeliveryHandler));
        ActiveMQJmsConnectorTestCase.assertFalse((boolean)c.isDurable());
        ActiveMQJmsConnectorTestCase.assertFalse((boolean)c.isNoLocal());
        ActiveMQJmsConnectorTestCase.assertFalse((boolean)c.isPersistentDelivery());
        ActiveMQJmsConnectorTestCase.assertEquals((int)0, (int)c.getMaxRedelivery());
        ActiveMQJmsConnectorTestCase.assertFalse((boolean)c.isCacheJmsSessions());
        ActiveMQJmsConnectorTestCase.assertFalse((boolean)c.isEagerConsumer());
        ActiveMQJmsConnectorTestCase.assertEquals((String)"1.0.2b", (String)c.getSpecification());
    }

    public void testCustomActiveMqConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("customActiveMqJmsConnector");
        ActiveMQJmsConnectorTestCase.assertNotNull((Object)c);
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        ActiveMQJmsConnectorTestCase.assertNotNull((Object)c.getConnectionFactory());
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)(c.getConnectionFactory() instanceof ActiveMQConnectionFactory));
        ActiveMQJmsConnectorTestCase.assertEquals((int)3, (int)c.getAcknowledgementMode());
        ActiveMQJmsConnectorTestCase.assertNull((Object)c.getUsername());
        ActiveMQJmsConnectorTestCase.assertNull((Object)c.getPassword());
        ActiveMQJmsConnectorTestCase.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof TestRedeliveryHandler));
        ActiveMQJmsConnectorTestCase.assertEquals((String)"myClient", (String)c.getClientId());
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)c.isDurable());
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)c.isNoLocal());
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)c.isPersistentDelivery());
        ActiveMQJmsConnectorTestCase.assertEquals((int)5, (int)c.getMaxRedelivery());
        ActiveMQJmsConnectorTestCase.assertTrue((boolean)c.isCacheJmsSessions());
        ActiveMQJmsConnectorTestCase.assertFalse((boolean)c.isEagerConsumer());
        ActiveMQJmsConnectorTestCase.assertEquals((String)"1.1", (String)c.getSpecification());
    }
}

