/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import com.mockobjects.constraint.IsInstanceOf;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.jms.JmsMessageUtils;

public class JmsMessageUtilsTestCase
extends AbstractMuleTestCase {
    public static final String ENCODING = "UTF-8";

    public void testHeaders() {
        JmsMessageUtilsTestCase.assertSame((Object)"identifier", (Object)JmsMessageUtils.encodeHeader((String)"identifier"));
        JmsMessageUtilsTestCase.assertSame((Object)"_identifier", (Object)JmsMessageUtils.encodeHeader((String)"_identifier"));
        JmsMessageUtilsTestCase.assertSame((Object)"identifier_", (Object)JmsMessageUtils.encodeHeader((String)"identifier_"));
        JmsMessageUtilsTestCase.assertSame((Object)"ident_ifier", (Object)JmsMessageUtils.encodeHeader((String)"ident_ifier"));
        JmsMessageUtilsTestCase.assertEquals((String)"_identifier", (String)JmsMessageUtils.encodeHeader((String)"-identifier"));
        JmsMessageUtilsTestCase.assertEquals((String)"identifier_", (String)JmsMessageUtils.encodeHeader((String)"identifier-"));
        JmsMessageUtilsTestCase.assertEquals((String)"ident_ifier", (String)JmsMessageUtils.encodeHeader((String)"ident-ifier"));
        JmsMessageUtilsTestCase.assertEquals((String)"_ident_ifier_", (String)JmsMessageUtils.encodeHeader((String)"-ident_ifier-"));
        JmsMessageUtilsTestCase.assertEquals((String)"_ident_ifier_", (String)JmsMessageUtils.encodeHeader((String)"-ident-ifier-"));
    }

    public void testTextMessageNullContent() throws Exception {
        Mock mockMessage = new Mock(TextMessage.class);
        mockMessage.expectAndReturn("getText", null);
        TextMessage mockTextMessage = (TextMessage)mockMessage.proxy();
        byte[] result = JmsMessageUtils.toByteArray((Message)mockTextMessage, (String)"1.0.2b", (String)ENCODING);
        JmsMessageUtilsTestCase.assertNotNull((Object)result);
        JmsMessageUtilsTestCase.assertEquals((String)"Should return an empty byte array.", (int)0, (int)result.length);
        mockMessage.verify();
    }

    public void testByteMessageNullContent() throws Exception {
        Mock mockMessage = new Mock(BytesMessage.class);
        mockMessage.expect("reset");
        mockMessage.expectAndReturn("readBytes", (Object)new IsInstanceOf(byte[].class), -1);
        BytesMessage mockBytesMessage = (BytesMessage)mockMessage.proxy();
        byte[] result = JmsMessageUtils.toByteArray((Message)mockBytesMessage, (String)"1.0.2b", (String)ENCODING);
        JmsMessageUtilsTestCase.assertNotNull((Object)result);
        JmsMessageUtilsTestCase.assertEquals((String)"Should return an empty byte array.", (int)0, (int)result.length);
        mockMessage.verify();
        mockMessage = new Mock(BytesMessage.class);
        mockMessage.expect("reset");
        mockMessage.expectAndReturn("getBodyLength", (Object)new Long(0L));
        mockBytesMessage = (BytesMessage)mockMessage.proxy();
        result = JmsMessageUtils.toByteArray((Message)mockBytesMessage, (String)"1.1", (String)ENCODING);
        JmsMessageUtilsTestCase.assertNotNull((Object)result);
        JmsMessageUtilsTestCase.assertEquals((String)"Should return an empty byte array.", (int)0, (int)result.length);
        mockMessage.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamMessageSerialization() throws Exception {
        Session session = null;
        try {
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
            session = cf.createConnection().createSession(false, 1);
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(new Object());
            try {
                JmsMessageUtils.toMessage(data, (Session)session);
                JmsMessageUtilsTestCase.fail((String)"Should've failed with MessageFormatException");
            }
            catch (MessageFormatException e) {
                // empty catch block
            }
            data.clear();
            data.add(Boolean.TRUE);
            data.add(new Byte("1"));
            data.add(new Short("2"));
            data.add(new Character('3'));
            data.add(new Integer("4"));
            data.add(new Float("6"));
            data.add(new Double("7"));
            data.add(new String("8"));
            data.add(new byte[]{9, 10});
            StreamMessage result = (StreamMessage)JmsMessageUtils.toMessage(data, (Session)session);
            result.reset();
            JmsMessageUtilsTestCase.assertEquals((Object)Boolean.TRUE, (Object)result.readObject());
            JmsMessageUtilsTestCase.assertEquals((Object)new Byte("1"), (Object)result.readObject());
            JmsMessageUtilsTestCase.assertEquals((Object)new Short("2"), (Object)result.readObject());
            JmsMessageUtilsTestCase.assertEquals((Object)new Character('3'), (Object)result.readObject());
            JmsMessageUtilsTestCase.assertEquals((Object)new Integer("4"), (Object)result.readObject());
            JmsMessageUtilsTestCase.assertEquals((Object)new Float("6"), (Object)result.readObject());
            JmsMessageUtilsTestCase.assertEquals((Object)new Double("7"), (Object)result.readObject());
            JmsMessageUtilsTestCase.assertEquals((Object)new String("8"), (Object)result.readObject());
            JmsMessageUtilsTestCase.assertTrue((boolean)Arrays.equals(new byte[]{9, 10}, (byte[])result.readObject()));
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

