/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import junit.framework.Assert;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public abstract class AbstractJmsFunctionalTestCase
extends FunctionalTestCase {
    public static final String DEFAULT_INPUT_MESSAGE = "INPUT MESSAGE";
    public static final String DEFAULT_OUTPUT_MESSAGE = "OUTPUT MESSAGE";
    public static final String INBOUND_ENDPOINT_KEY = "inbound.destination";
    public static final String OUTBOUND_ENDPOINT_KEY = "outbound.destination";
    public static final String MIDDLE_ENDPOINT_KEY = "middle.destination";
    public static final String MIDDLE2_ENDPOINT_KEY = "middle2.destination";
    public static final String BROADCAST_TOPIC_ENDPOINT_KEY = "broadcast.topic.destination";
    private MuleClient client;
    private JmsVendorConfiguration jmsConfig;
    protected Scenario scenarioNoTx;
    protected Scenario scenarioCommit;
    protected Scenario scenarioRollback;
    protected Scenario scenarioNotReceive;
    protected Scenario scenarioReceive;

    public AbstractJmsFunctionalTestCase(JmsVendorConfiguration config) {
        this.setJmsConfig(config);
        this.scenarioNoTx = new NonTransactedScenario();
        this.scenarioCommit = new ScenarioCommit();
        this.scenarioRollback = new ScenarioRollback();
        this.scenarioNotReceive = new ScenarioNotReceive();
        this.scenarioReceive = new ScenarioReceive();
    }

    protected Properties getStartUpProperties() {
        Properties props = new Properties();
        props.put(INBOUND_ENDPOINT_KEY, this.getJmsConfig().getInboundEndpoint());
        props.put(OUTBOUND_ENDPOINT_KEY, this.getJmsConfig().getOutboundEndpoint());
        props.put(MIDDLE_ENDPOINT_KEY, this.getJmsConfig().getMiddleEndpoint());
        props.put(MIDDLE2_ENDPOINT_KEY, this.getJmsConfig().getMiddleEndpoint() + "2");
        props.put(BROADCAST_TOPIC_ENDPOINT_KEY, this.getJmsConfig().getTopicBroadcastEndpoint());
        props.put("protocol", this.getJmsConfig().getProtocol());
        Map p = this.getJmsConfig().getProperties();
        if (p != null) {
            props.putAll((Map<?, ?>)p);
        }
        return props;
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        String resources = this.getConfigResources().substring(this.getConfigResources().lastIndexOf("/") + 1);
        resources = String.format("integration/%s/connector-%s,%s", this.getJmsConfig().getProviderName(), resources, this.getConfigResources());
        SpringXmlConfigurationBuilder builder = new SpringXmlConfigurationBuilder(resources);
        return builder;
    }

    public final JmsVendorConfiguration getJmsConfig() {
        if (this.jmsConfig == null) {
            this.jmsConfig = this.creatJmsConfig();
        }
        return this.jmsConfig;
    }

    public final void setJmsConfig(JmsVendorConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected JmsVendorConfiguration creatJmsConfig() {
        return null;
    }

    protected Connection getConnection(boolean topic, boolean xa) throws Exception {
        this.checkConfig();
        return this.getJmsConfig().getConnection(topic, xa);
    }

    protected String getInboundEndpoint() {
        this.checkConfig();
        return this.getJmsConfig().getInboundEndpoint();
    }

    protected String getOutboundEndpoint() {
        this.checkConfig();
        return this.getJmsConfig().getOutboundEndpoint();
    }

    protected String getInboundQueueName() {
        this.checkConfig();
        return this.getJmsConfig().getInboundDestinationName();
    }

    protected String getOutboundQueueName() {
        this.checkConfig();
        return this.getJmsConfig().getOutboundDestinationName();
    }

    protected long getSmallTimeout() {
        this.checkConfig();
        return this.getJmsConfig().getSmallTimeout();
    }

    protected long getTimeout() {
        this.checkConfig();
        return this.getJmsConfig().getTimeout();
    }

    protected void checkConfig() {
        if (this.getJmsConfig() == null) {
            throw new IllegalStateException("There must be a Jms Vendor config set on this test");
        }
    }

    protected void dispatchMessage() throws Exception {
        this.client.dispatch(this.getInboundEndpoint(), (Object)DEFAULT_INPUT_MESSAGE, null);
    }

    protected void dispatchMessage(Object payload) throws Exception {
        this.client.dispatch(this.getInboundEndpoint(), payload, null);
    }

    protected MuleMessage receiveMessage() throws Exception {
        MuleMessage result = this.client.request(this.getOutboundEndpoint(), this.getTimeout());
        AbstractJmsFunctionalTestCase.assertNotNull((Object)result);
        AbstractJmsFunctionalTestCase.assertNotNull((Object)result.getPayload());
        AbstractJmsFunctionalTestCase.assertNull((Object)result.getExceptionPayload());
        AbstractJmsFunctionalTestCase.assertEquals((Object)DEFAULT_OUTPUT_MESSAGE, (Object)result.getPayload());
        return result;
    }

    public void runAsynchronousDispatching() throws Exception {
        this.dispatchMessage();
        this.receiveMessage();
        MuleMessage result = this.client.request(this.getOutboundEndpoint(), this.getSmallTimeout());
        AbstractJmsFunctionalTestCase.assertNull((Object)result);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client = new MuleClient();
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.client.dispose();
    }

    protected MuleClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Scenario scenario) throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection(false, false);
            connection.start();
            Session session = null;
            try {
                session = connection.createSession(scenario.isTransacted(), scenario.getAcknowledge());
                Destination destination = this.createInputDestination(session, scenario);
                MessageProducer producer = null;
                try {
                    producer = session.createProducer(destination);
                    if (scenario.isPersistent()) {
                        producer.setDeliveryMode(2);
                    }
                    scenario.send(session, producer);
                }
                finally {
                    if (producer != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    protected Destination createInputDestination(Session session, Scenario scenario) throws JMSException {
        return session.createQueue(scenario.getInputDestinationName());
    }

    protected Destination createOutputDestination(Session session, Scenario scenario) throws JMSException {
        return session.createQueue(scenario.getOutputDestinationName());
    }

    /*
     * Exception decompiling
     */
    public Message receive(Scenario scenario) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected class ScenarioReceive
    extends NonTransactedScenario {
        protected ScenarioReceive() {
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(AbstractJmsFunctionalTestCase.this.getTimeout());
            Assert.assertNotNull((Object)message);
            return message;
        }
    }

    protected class ScenarioNotReceive
    extends NonTransactedScenario {
        protected ScenarioNotReceive() {
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(AbstractJmsFunctionalTestCase.this.getSmallTimeout());
            Assert.assertNull((Object)message);
            return message;
        }
    }

    protected class ScenarioRollback
    extends AbstractScenario {
        protected ScenarioRollback() {
        }

        public boolean isTransacted() {
            return true;
        }

        protected void applyTransaction(Session session) throws JMSException {
            session.rollback();
        }
    }

    protected class ScenarioCommit
    extends AbstractScenario {
        protected ScenarioCommit() {
        }

        public boolean isTransacted() {
            return true;
        }

        protected void applyTransaction(Session session) throws JMSException {
            session.commit();
        }
    }

    protected class NonTransactedScenario
    extends AbstractScenario {
        protected NonTransactedScenario() {
        }

        public boolean isTransacted() {
            return false;
        }

        protected void applyTransaction(Session session) throws JMSException {
        }
    }

    protected abstract class AbstractScenario
    implements Scenario {
        private String inputQueue;
        private String outputQueue;
        private boolean persistent;

        protected AbstractScenario() {
            this.inputQueue = AbstractJmsFunctionalTestCase.this.getInboundQueueName();
            this.outputQueue = AbstractJmsFunctionalTestCase.this.getOutboundQueueName();
            this.persistent = false;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }

        public String getInputDestinationName() {
            return this.inputQueue;
        }

        public String getOutputDestinationName() {
            return this.outputQueue;
        }

        public void setInputDestinationName(String inputQueue) {
            this.inputQueue = inputQueue;
        }

        public void setOutputDestinationName(String outputQueue) {
            this.outputQueue = outputQueue;
        }

        public int getAcknowledge() {
            return 1;
        }

        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage(AbstractJmsFunctionalTestCase.DEFAULT_INPUT_MESSAGE));
            this.applyTransaction(session);
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(AbstractJmsFunctionalTestCase.this.getTimeout());
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((String)AbstractJmsFunctionalTestCase.DEFAULT_OUTPUT_MESSAGE, (String)((TextMessage)message).getText());
            this.applyTransaction(session);
            return message;
        }

        protected abstract void applyTransaction(Session var1) throws JMSException;
    }

    protected static interface Scenario {
        public boolean isPersistent();

        public void setPersistent(boolean var1);

        public String getInputDestinationName();

        public void setInputDestinationName(String var1);

        public String getOutputDestinationName();

        public void setOutputDestinationName(String var1);

        public int getAcknowledge();

        public void send(Session var1, MessageProducer var2) throws JMSException, SystemException, HeuristicMixedException, HeuristicRollbackException, RollbackException;

        public Message receive(Session var1, MessageConsumer var2) throws JMSException, SystemException, HeuristicMixedException, HeuristicRollbackException, RollbackException;

        public boolean isTransacted();
    }
}

