/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import junit.framework.Assert;
import org.mule.message.ExceptionMessage;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public abstract class JmsExceptionStrategyTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String DEADLETTER_QUEUE_NAME = "dead.letter";
    AbstractJmsFunctionalTestCase.Scenario scenarioDeadLetter = new ScenarioDeadLetter();
    AbstractJmsFunctionalTestCase.Scenario scenarioDeadLetterRollback = new ScenarioDeadLetterRollback();
    AbstractJmsFunctionalTestCase.Scenario scenarioDeadLetterNotReceive = new ScenarioDeadLetterNotReceive();

    public JmsExceptionStrategyTestCase(JmsVendorConfiguration config) {
        super(config);
    }

    protected String getConfigResources() {
        return "integration/jms-exception-strategy.xml";
    }

    public void testTransactedRedeliveryToDLDestination() throws Exception {
        this.send(this.scenarioDeadLetter);
        this.receive(this.scenarioNotReceive);
        this.receive(this.scenarioDeadLetter);
    }

    public void testTransactedRedeliveryToDLDestinationRollback() throws Exception {
        this.send(this.scenarioDeadLetter);
        this.receive(this.scenarioDeadLetterRollback);
        this.receive(this.scenarioDeadLetter);
        this.receive(this.scenarioDeadLetterNotReceive);
    }

    class ScenarioDeadLetterNotReceive
    extends ScenarioDeadLetter {
        ScenarioDeadLetterNotReceive() {
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(JmsExceptionStrategyTestCase.this.getSmallTimeout());
            Assert.assertNull((Object)message);
            return message;
        }
    }

    class ScenarioDeadLetterRollback
    extends ScenarioDeadLetter {
        ScenarioDeadLetterRollback() {
        }

        protected void applyTransaction(Session session) throws JMSException {
            session.rollback();
        }
    }

    class ScenarioDeadLetter
    extends AbstractJmsFunctionalTestCase.ScenarioCommit {
        ScenarioDeadLetter() {
        }

        public String getOutputDestinationName() {
            return JmsExceptionStrategyTestCase.DEADLETTER_QUEUE_NAME;
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(JmsExceptionStrategyTestCase.this.getTimeout());
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((String)("Message should be ObjectMessage but is " + message.getClass()), (boolean)(message instanceof ObjectMessage));
            Serializable obj = ((ObjectMessage)message).getObject();
            Assert.assertTrue((boolean)(obj instanceof ExceptionMessage));
            Assert.assertEquals((Object)"INPUT MESSAGE", (Object)((ExceptionMessage)obj).getPayload());
            String dest = message.getStringProperty("MULE_ENDPOINT");
            Assert.assertNotNull((Object)dest);
            Assert.assertEquals((String)"jms://dead.letter", (String)dest);
            this.applyTransaction(session);
            return message;
        }
    }
}

