/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import junit.framework.Assert;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public abstract class JmsMuleSideDurableTopicTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String CONNECTOR1_NAME = "jmsConnectorC1";
    AbstractJmsFunctionalTestCase.Scenario scenarioNoTx = new AbstractJmsFunctionalTestCase.NonTransactedScenario(){

        public String getInputDestinationName() {
            return JmsMuleSideDurableTopicTestCase.this.getJmsConfig().getBroadcastDestinationName();
        }

        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage("INPUT MESSAGE"));
        }

        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(JmsMuleSideDurableTopicTestCase.this.getTimeout());
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((String)((TextMessage)message).getText(), (String)"OUTPUT MESSAGE");
            return message;
        }
    };

    public JmsMuleSideDurableTopicTestCase(JmsVendorConfiguration config) {
        super(config);
    }

    protected String getConfigResources() {
        return "integration/jms-muleside-durable-topic.xml";
    }

    public void testMuleDurableSubscriber() throws Exception {
        this.send(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
        muleContext.getRegistry().lookupConnector(CONNECTOR1_NAME).stop();
        JmsMuleSideDurableTopicTestCase.assertEquals((boolean)muleContext.getRegistry().lookupConnector(CONNECTOR1_NAME).isStarted(), (boolean)false);
        this.logger.info((Object)"jmsConnectorC1 is stopped");
        this.send(this.scenarioNoTx);
        muleContext.getRegistry().lookupConnector(CONNECTOR1_NAME).start();
        this.logger.info((Object)"jmsConnectorC1 is started");
        this.receive(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(AbstractJmsFunctionalTestCase.Scenario scenario) throws Exception {
        TopicConnection connection = null;
        try {
            connection = (TopicConnection)this.getConnection(true, false);
            connection.start();
            TopicSession session = null;
            try {
                session = connection.createTopicSession(scenario.isTransacted(), scenario.getAcknowledge());
                Topic destination = session.createTopic(scenario.getInputDestinationName());
                TopicPublisher publisher = null;
                try {
                    publisher = session.createPublisher(destination);
                    publisher.setDeliveryMode(2);
                    scenario.send((Session)session, (MessageProducer)publisher);
                }
                finally {
                    if (publisher != null) {
                        publisher.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

