/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration.activemq;

import java.util.Map;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public class ActiveMQJmsConfiguration
implements JmsVendorConfiguration {
    public static final String DEFAULT_BROKER_URL = "vm://localhost?broker.persistent=false&broker.useJmx=false";

    public Connection getConnection(boolean topic, boolean xa) throws Exception {
        if (xa) {
            return new ActiveMQXAConnectionFactory(DEFAULT_BROKER_URL).createConnection();
        }
        return new ActiveMQConnectionFactory(DEFAULT_BROKER_URL).createConnection();
    }

    public String getInboundEndpoint() {
        return this.getProtocol() + "://" + this.getInboundDestinationName();
    }

    public String getOutboundEndpoint() {
        return this.getProtocol() + "://" + this.getOutboundDestinationName();
    }

    public String getMiddleEndpoint() {
        return this.getProtocol() + "://" + this.getMiddleDestinationName();
    }

    public String getTopicBroadcastEndpoint() {
        return this.getProtocol() + "://topic:" + this.getBroadcastDestinationName();
    }

    public String getInboundDestinationName() {
        return "in";
    }

    public String getOutboundDestinationName() {
        return "out";
    }

    public String getMiddleDestinationName() {
        return "middle";
    }

    public String getBroadcastDestinationName() {
        return "broadcast";
    }

    public long getSmallTimeout() {
        return 1000L;
    }

    public long getTimeout() {
        return 5000L;
    }

    public String getProtocol() {
        return "jms";
    }

    public String getProviderName() {
        return "activemq";
    }

    public Map getProperties() {
        return null;
    }
}

