/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import com.mockobjects.dynamic.Mock;
import java.util.Iterator;
import javax.jms.TextMessage;
import org.apache.commons.collections.IteratorUtils;
import org.mule.api.MessagingException;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageAdapterTestCase;
import org.mule.transport.jms.JmsMessageAdapter;

public class JmsMessageAdapterTestCase
extends AbstractMessageAdapterTestCase {
    public MessageAdapter createAdapter(Object payload) throws MessagingException {
        return new JmsMessageAdapter(payload);
    }

    public Object getValidMessage() throws Exception {
        Mock message = new Mock(TextMessage.class);
        message.expectAndReturn("getText", (Object)"Test JMS Message");
        message.expectAndReturn("getText", (Object)"Test JMS Message");
        message.expectAndReturn("getJMSCorrelationID", null);
        message.expectAndReturn("getJMSMessageID", (Object)"1234567890");
        message.expectAndReturn("getJMSDeliveryMode", (Object)new Integer(1));
        message.expectAndReturn("getJMSDestination", null);
        message.expectAndReturn("getJMSPriority", (Object)new Integer(4));
        message.expectAndReturn("getJMSRedelivered", (Object)Boolean.FALSE);
        message.expectAndReturn("getJMSReplyTo", null);
        message.expectAndReturn("getJMSExpiration", (Object)new Long(0L));
        message.expectAndReturn("getJMSTimestamp", (Object)new Long(0L));
        message.expectAndReturn("getJMSType", null);
        message.expect("toString");
        message.expectAndReturn("getPropertyNames", (Object)IteratorUtils.asEnumeration((Iterator)IteratorUtils.emptyIterator()));
        return message.proxy();
    }

    public void testIllegalSpecification() throws Exception {
        JmsMessageAdapter a = (JmsMessageAdapter)this.createAdapter(this.getValidMessage());
        a.setSpecification("1.0.2b");
        a.setSpecification("1.1");
        try {
            a.setSpecification("1.2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

