/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.mule.api.MuleEventContext;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.functional.CounterCallback;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.jms.MessageRedeliveredException;
import org.mule.util.concurrent.Latch;

public class JmsRedeliveryTestCase
extends FunctionalTestCase {
    private final int timeout = this.getTimeoutSecs() * 1000 / 4;
    private static final String DESTINATION = "jms://in";

    protected String getConfigResources() {
        return "jms-redelivery.xml";
    }

    public void testRedelivery() throws Exception {
        MuleClient client = new MuleClient();
        while (client.request(DESTINATION, 1000L) != null) {
            this.logger.warn((Object)"Destination jms://in isn't empty, draining it");
        }
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("Bouncer");
        final Latch mrexFired = new Latch();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener(){

            public void onNotification(ServerNotification notification) {
                ExceptionNotification n = (ExceptionNotification)notification;
                if (n.getException() instanceof MessageRedeliveredException) {
                    mrexFired.countDown();
                }
            }
        });
        CounterCallback callback = new CounterCallback(){

            public void eventReceived(MuleEventContext context, Object Component) throws Exception {
                int count = this.incCallbackCount();
                JmsRedeliveryTestCase.this.logger.info((Object)("Message Delivery Count is: " + count));
                throw new FunctionalTestException();
            }
        };
        ftc.setEventCallback((EventCallback)callback);
        client.dispatch(DESTINATION, (Object)"test", null);
        mrexFired.await((long)this.timeout, TimeUnit.MILLISECONDS);
        JmsRedeliveryTestCase.assertEquals((String)"MessageRedeliveredException never fired.", (long)0L, (long)mrexFired.getCount());
        JmsRedeliveryTestCase.assertEquals((String)"Wrong number of delivery attempts", (int)4, (int)callback.getCallbackCount());
    }
}

