/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.junit.Test;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public class JmsClientAcknowledgeTransactionTestCase
extends AbstractJmsFunctionalTestCase {
    public JmsClientAcknowledgeTransactionTestCase(JmsVendorConfiguration config) {
        super(config);
    }

    protected String getConfigResources() {
        return "integration/jms-client-acknowledge-tx.xml";
    }

    public int getAcknowledgeMode() {
        return 2;
    }

    @Test
    public void testJmsClientAcknowledgeTransaction() throws Exception {
        this.send();
        Message output = this.receive();
        this.assertPayloadEquals("OUTPUT MESSAGE", output);
        output = this.receive(new AbstractJmsFunctionalTestCase.MessagePostProcessor(){

            public void postProcess(Session session, Message message) throws JMSException {
                message.acknowledge();
            }
        });
        this.assertPayloadEquals("OUTPUT MESSAGE", output);
        output = this.receiveNoWait();
        JmsClientAcknowledgeTransactionTestCase.assertNull((Object)output);
    }
}

