/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import org.junit.Test;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public class JmsHeaderReplyToTestCase
extends AbstractJmsFunctionalTestCase {
    public JmsHeaderReplyToTestCase(JmsVendorConfiguration config) {
        super(config);
    }

    protected String getConfigResources() {
        return "integration/jms-header-replyto.xml";
    }

    protected Message createJmsMessage(Object payload, Session session) throws JMSException {
        Message message = super.createJmsMessage(payload, session);
        Queue dest = session.createQueue(this.getJmsConfig().getOutboundDestinationName());
        message.setJMSReplyTo((Destination)dest);
        return message;
    }

    @Test
    public void testTranspJmsH1() throws Exception {
        Message input = this.send("INPUT MESSAGE");
        Message output = this.receive();
        JmsHeaderReplyToTestCase.assertEquals((String)input.getJMSMessageID(), (String)output.getJMSCorrelationID());
        JmsHeaderReplyToTestCase.assertNull((Object)this.receiveNoWait());
    }
}

