/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;
import org.mule.transport.jms.integration.SessionEnabledObjectToJMSMessage;

public class JmsMessageAwareTransformersMule2685TestCase
extends AbstractJmsFunctionalTestCase {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Session session = null;

    public JmsMessageAwareTransformersMule2685TestCase(JmsVendorConfiguration config) {
        super(config);
    }

    protected String getConfigResources() {
        return "integration/jms-transformers.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = this.getConnection(false, false).createSession(false, 1);
    }

    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Test
    public void testMessageAwareTransformerChainedWithObjectToJMSMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsMessageAwareTransformersMule2685TestCase.getTestEvent((Object)"test"));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"This is a test TextMessage");
        SetTestRecipientsTransformer trans = new SetTestRecipientsTransformer();
        MuleMessage result1 = (MuleMessage)trans.transform(message);
        JmsMessageAwareTransformersMule2685TestCase.assertEquals((Object)"vm://recipient1, vm://recipient1, vm://recipient3", (Object)result1.getProperty("recipients"));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        Message result2 = (Message)trans2.transform(result1);
        JmsMessageAwareTransformersMule2685TestCase.assertTrue((String)"Transformed object should be a TextMessage", (boolean)(result2 instanceof TextMessage));
        JmsMessageAwareTransformersMule2685TestCase.assertEquals((String)"This is a test TextMessage", (String)((TextMessage)result2).getText());
        JmsMessageAwareTransformersMule2685TestCase.assertEquals((String)"vm://recipient1, vm://recipient1, vm://recipient3", (String)result2.getStringProperty("recipients"));
    }

    private class SetTestRecipientsTransformer
    extends AbstractMessageAwareTransformer {
        public SetTestRecipientsTransformer() {
            this.registerSourceType(MuleMessage.class);
        }

        public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
            String recipients = "vm://recipient1, vm://recipient1, vm://recipient3";
            this.logger.debug((Object)("Setting recipients to '" + recipients + "'"));
            message.setProperty("recipients", (Object)recipients);
            return message;
        }
    }
}

