/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.junit.Test;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public class JmsSingleTransactionAlwaysBeginConfigurationTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String JMS_QUEUE_INPUT_CONF_A = "in1";
    public static final String JMS_QUEUE_OUTPUT_CONF_A = "out1";
    public static final String JMS_QUEUE_INPUT_CONF_B = "in2";
    public static final String JMS_QUEUE_OUTPUT_CONF_B = "out2";
    public static final String JMS_QUEUE_INPUT_CONF_C = "in3";
    public static final String JMS_QUEUE_OUTPUT_CONF_C = "out3";
    AbstractJmsFunctionalTestCase.MessagePostProcessor commit = new AbstractJmsFunctionalTestCase.MessagePostProcessor(){

        public void postProcess(Session session, Message message) throws JMSException {
            session.commit();
        }
    };
    AbstractJmsFunctionalTestCase.MessagePostProcessor rollback = new AbstractJmsFunctionalTestCase.MessagePostProcessor(){

        public void postProcess(Session session, Message message) throws JMSException {
            session.rollback();
        }
    };

    protected Properties getStartUpProperties() {
        Properties props = super.getStartUpProperties();
        props.put("inbound.destination1", this.getJmsConfig().getInboundEndpoint() + "1");
        props.put("inbound.destination2", this.getJmsConfig().getInboundEndpoint() + "2");
        props.put("inbound.destination3", this.getJmsConfig().getInboundEndpoint() + "3");
        props.put("outbound.destination1", this.getJmsConfig().getOutboundEndpoint() + "1");
        props.put("outbound.destination2", this.getJmsConfig().getOutboundEndpoint() + "2");
        props.put("outbound.destination3", this.getJmsConfig().getOutboundEndpoint() + "3");
        return props;
    }

    public JmsSingleTransactionAlwaysBeginConfigurationTestCase(JmsVendorConfiguration config) {
        super(config);
        this.setTransacted(true);
    }

    protected String getConfigResources() {
        return "integration/jms-single-tx-ALWAYS_BEGIN.xml";
    }

    @Test
    public void testConfigurationA() throws Exception {
        this.send(JMS_QUEUE_INPUT_CONF_A, "INPUT MESSAGE", this.commit);
        this.assertPayloadEquals("OUTPUT MESSAGE", this.receive(JMS_QUEUE_OUTPUT_CONF_A, this.getTimeout(), this.rollback));
        this.assertPayloadEquals("OUTPUT MESSAGE", this.receive(JMS_QUEUE_OUTPUT_CONF_A, this.getTimeout(), this.commit));
        JmsSingleTransactionAlwaysBeginConfigurationTestCase.assertNull((Object)this.receive(JMS_QUEUE_OUTPUT_CONF_A, this.getTimeout(), null));
    }

    @Test
    public void testConfigurationB() throws Exception {
        this.send(JMS_QUEUE_INPUT_CONF_B, "INPUT MESSAGE", this.commit);
        this.assertPayloadEquals("OUTPUT MESSAGE", this.receive(JMS_QUEUE_OUTPUT_CONF_B, this.getTimeout(), this.rollback));
        this.assertPayloadEquals("OUTPUT MESSAGE", this.receive(JMS_QUEUE_OUTPUT_CONF_B, this.getTimeout(), this.commit));
        JmsSingleTransactionAlwaysBeginConfigurationTestCase.assertNull((Object)this.receive(JMS_QUEUE_OUTPUT_CONF_B, this.getTimeout(), null));
    }

    @Test
    public void testConfigurationC() throws Exception {
        this.send(JMS_QUEUE_INPUT_CONF_C, "INPUT MESSAGE", this.commit);
        this.assertPayloadEquals("OUTPUT MESSAGE", this.receive(JMS_QUEUE_OUTPUT_CONF_C, this.getTimeout(), this.rollback));
        this.assertPayloadEquals("OUTPUT MESSAGE", this.receive(JMS_QUEUE_OUTPUT_CONF_C, this.getTimeout(), this.commit));
        JmsSingleTransactionAlwaysBeginConfigurationTestCase.assertNull((Object)this.receive(JMS_QUEUE_OUTPUT_CONF_C, this.getTimeout(), null));
    }
}

