/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingDeque;
import java.util.ArrayList;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.MessageFactory;
import org.mule.transaction.TransactionCollection;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractReceiverWorker;
import org.mule.transport.ConnectException;
import org.mule.transport.jms.JmsClientAcknowledgeTransaction;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.JmsTransaction;
import org.mule.transport.jms.RedeliveryHandler;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.util.ClassUtils;

public class MultiConsumerJmsMessageReceiver
extends AbstractMessageReceiver {
    protected final BlockingDeque consumers;
    protected volatile int receiversCount;
    private final JmsConnector jmsConnector;

    public MultiConsumerJmsMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
        this.jmsConnector = (JmsConnector)connector;
        boolean isTopic = this.jmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)endpoint, true);
        this.receiversCount = this.jmsConnector.getNumberOfConsumers();
        if (isTopic && this.receiversCount != 1) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Destination " + this.getEndpoint().getEndpointURI() + " is a topic, but " + this.receiversCount + " receivers have been requested. Will configure only 1."));
            }
            this.receiversCount = 1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating " + this.receiversCount + " sub-receivers for " + endpoint.getEndpointURI()));
        }
        this.consumers = new LinkedBlockingDeque(this.receiversCount);
    }

    protected void doStart() throws MuleException {
        this.logger.debug((Object)"doStart()");
        for (SubReceiver sub : this.consumers) {
            sub.doStart();
        }
    }

    protected void doStop() throws MuleException {
        this.logger.debug((Object)"doStop()");
        if (this.consumers != null) {
            for (SubReceiver sub : this.consumers) {
                sub.doStop(true);
            }
        }
    }

    protected void doConnect() throws Exception {
        this.logger.debug((Object)"doConnect()");
        for (int i = 0; i < this.receiversCount; ++i) {
            SubReceiver sub = new SubReceiver();
            sub.doConnect();
            this.consumers.add((Object)sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws Exception {
        this.logger.debug((Object)"doDisconnect()");
        for (SubReceiver sub : this.consumers) {
            Object var4_3;
            try {
                sub.doDisconnect();
                var4_3 = null;
                sub = null;
            }
            catch (Throwable throwable) {
                var4_3 = null;
                sub = null;
                throw throwable;
            }
        }
        this.consumers.clear();
    }

    protected void doDispose() {
        this.logger.debug((Object)"doDispose()");
    }

    protected class JmsWorker
    extends AbstractReceiverWorker {
        private final SubReceiver subReceiver;

        public JmsWorker(Message message, AbstractMessageReceiver receiver, SubReceiver subReceiver) {
            super(new ArrayList(1), receiver);
            this.subReceiver = subReceiver;
            this.messages.add(message);
        }

        protected Object preProcessMessage(Object message) throws Exception {
            Message m = (Message)message;
            if (MultiConsumerJmsMessageReceiver.this.logger.isDebugEnabled()) {
                MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message received it is of type: " + ClassUtils.getSimpleName(message.getClass())));
                if (m.getJMSDestination() != null) {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message received on " + m.getJMSDestination() + " (" + m.getJMSDestination().getClass().getName() + ")"));
                } else {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)"Message received on unknown destination");
                }
                MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message CorrelationId is: " + m.getJMSCorrelationID()));
                MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Jms Message Id is: " + m.getJMSMessageID()));
            }
            if (m.getJMSRedelivered()) {
                RedeliveryHandler redeliveryHandler = MultiConsumerJmsMessageReceiver.this.jmsConnector.getRedeliveryHandlerFactory().create();
                redeliveryHandler.setConnector(MultiConsumerJmsMessageReceiver.this.jmsConnector);
                if (MultiConsumerJmsMessageReceiver.this.logger.isDebugEnabled()) {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message with correlationId: " + m.getJMSCorrelationID() + " has redelivered flag set, handing off to Exception Handler"));
                }
                redeliveryHandler.handleRedelivery(m);
            }
            return m;
        }

        protected void bindTransaction(Transaction tx) throws TransactionException {
            if (tx instanceof JmsTransaction || tx instanceof TransactionCollection) {
                if (MultiConsumerJmsMessageReceiver.this.logger.isDebugEnabled()) {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Binding " + this.subReceiver.session + " to " + MultiConsumerJmsMessageReceiver.this.jmsConnector.getConnection()));
                }
                tx.bindResource((Object)MultiConsumerJmsMessageReceiver.this.jmsConnector.getConnection(), (Object)this.subReceiver.session);
            } else if (tx instanceof JmsClientAcknowledgeTransaction) {
                ((JmsClientAcknowledgeTransaction)tx).setMessage((Message)this.messages.get(0));
            }
        }
    }

    private class SubReceiver
    implements MessageListener {
        private final Log subLogger = LogFactory.getLog(this.getClass());
        private volatile Session session;
        private volatile MessageConsumer consumer;
        protected volatile boolean connected;
        protected volatile boolean started;

        private SubReceiver() {
        }

        protected void doConnect() throws MuleException {
            this.subLogger.debug((Object)"SUB doConnect()");
            try {
                this.createConsumer();
            }
            catch (Exception e) {
                throw new LifecycleException((Throwable)e, (Object)this);
            }
            this.connected = true;
        }

        protected void doDisconnect() throws MuleException {
            this.subLogger.debug((Object)"SUB doDisconnect()");
            if (this.started) {
                this.doStop(true);
            }
            this.closeConsumer();
            this.connected = false;
        }

        protected void closeConsumer() {
            MultiConsumerJmsMessageReceiver.this.jmsConnector.closeQuietly(this.consumer);
            this.consumer = null;
            MultiConsumerJmsMessageReceiver.this.jmsConnector.closeQuietly(this.session);
            this.session = null;
        }

        protected void doStart() throws MuleException {
            this.subLogger.debug((Object)"SUB doStart()");
            if (!this.connected) {
                this.doConnect();
            }
            try {
                this.consumer.setMessageListener((MessageListener)this);
                this.started = true;
            }
            catch (JMSException e) {
                throw new LifecycleException((Throwable)e, (Object)this);
            }
        }

        protected void doStop(boolean force) throws MuleException {
            this.subLogger.debug((Object)"SUB doStop()");
            if (this.consumer != null) {
                try {
                    this.consumer.setMessageListener(null);
                    this.started = false;
                }
                catch (JMSException e) {
                    if (force) {
                        MultiConsumerJmsMessageReceiver.this.logger.warn((Object)("Unable to cleanly stop subreceiver: " + e.getMessage()));
                        this.started = false;
                    }
                    throw new LifecycleException((Throwable)e, (Object)this);
                }
            }
        }

        protected void createConsumer() throws Exception {
            this.subLogger.debug((Object)"SUB createConsumer()");
            try {
                String durableName;
                JmsSupport jmsSupport = MultiConsumerJmsMessageReceiver.this.jmsConnector.getJmsSupport();
                boolean topic = MultiConsumerJmsMessageReceiver.this.jmsConnector.getTopicResolver().isTopic(MultiConsumerJmsMessageReceiver.this.endpoint, true);
                if (this.session == null) {
                    this.session = MultiConsumerJmsMessageReceiver.this.jmsConnector.getSession(MultiConsumerJmsMessageReceiver.this.endpoint);
                }
                Destination dest = jmsSupport.createDestination(this.session, MultiConsumerJmsMessageReceiver.this.endpoint);
                String selector = null;
                if (MultiConsumerJmsMessageReceiver.this.endpoint.getFilter() != null && MultiConsumerJmsMessageReceiver.this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                    selector = ((JmsSelectorFilter)MultiConsumerJmsMessageReceiver.this.endpoint.getFilter()).getExpression();
                } else if (MultiConsumerJmsMessageReceiver.this.endpoint.getProperties() != null) {
                    selector = (String)MultiConsumerJmsMessageReceiver.this.endpoint.getProperties().get("selector");
                }
                String tempDurable = (String)MultiConsumerJmsMessageReceiver.this.endpoint.getProperties().get("durable");
                boolean durable = MultiConsumerJmsMessageReceiver.this.jmsConnector.isDurable();
                if (tempDurable != null) {
                    durable = Boolean.valueOf(tempDurable);
                }
                if ((durableName = (String)MultiConsumerJmsMessageReceiver.this.endpoint.getProperties().get("durableName")) == null && durable && topic) {
                    durableName = "mule." + MultiConsumerJmsMessageReceiver.this.jmsConnector.getName() + "." + MultiConsumerJmsMessageReceiver.this.endpoint.getEndpointURI().getAddress();
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
                }
                this.consumer = jmsSupport.createConsumer(this.session, dest, selector, MultiConsumerJmsMessageReceiver.this.jmsConnector.isNoLocal(), durableName, topic);
            }
            catch (JMSException e) {
                throw new ConnectException((Throwable)e, (Object)MultiConsumerJmsMessageReceiver.this);
            }
        }

        public void onMessage(Message message) {
            try {
                MultiConsumerJmsMessageReceiver.this.getWorkManager().doWork((Work)new JmsWorker(message, MultiConsumerJmsMessageReceiver.this, this));
            }
            catch (WorkException e) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Couldn't submit a work item to the WorkManager"), (Throwable)e);
            }
        }
    }
}

