/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.config;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.activemq.ActiveMQJmsConnector;
import org.mule.transport.jms.weblogic.WeblogicJmsConnector;
import org.mule.transport.jms.websphere.WebsphereJmsConnector;

public class JmsVendorNamespaceHandlerTestCase
extends FunctionalTestCase {
    public JmsVendorNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigResources() {
        return "jms-vendor-namespace-config.xml";
    }

    public void testActiveMqDefault() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("activeMqConnectorDefaults");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        ConnectionFactory cf = c.getConnectionFactory();
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(cf instanceof ActiveMQConnectionFactory));
        JmsVendorNamespaceHandlerTestCase.assertEquals((String)"vm://localhost?broker.persistent=false&broker.useJmx=false", (String)((ActiveMQConnectionFactory)cf).getBrokerURL());
    }

    public void testActiveMqBrokerURL() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("activeMqConnectorBroker");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        ConnectionFactory cf = c.getConnectionFactory();
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(cf instanceof ActiveMQConnectionFactory));
        JmsVendorNamespaceHandlerTestCase.assertEquals((String)"tcp://localhost:1234", (String)((ActiveMQConnectionFactory)cf).getBrokerURL());
    }

    public void testWeblogicDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("weblogicConnector");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof WeblogicJmsConnector));
    }

    public void testWebsphereDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("websphereConnector");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof WebsphereJmsConnector));
    }
}

