/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.Message;
import org.junit.Test;
import org.mule.transport.jms.integration.JmsDurableTopicTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public class JmsDurableTopicSingleTxTestCase
extends JmsDurableTopicTestCase {
    public JmsDurableTopicSingleTxTestCase(JmsVendorConfiguration config) {
        super(config);
        this.setTransacted(true);
    }

    protected String getConfigResources() {
        return "integration/jms-durable-topic-single-tx.xml";
    }

    @Test
    public void testProviderDurableSubscriber() throws Exception {
        this.setClientId("Client1");
        JmsDurableTopicSingleTxTestCase.assertNull((Object)this.receiveNoWait());
        this.setClientId("Client2");
        JmsDurableTopicSingleTxTestCase.assertNull((Object)this.receiveNoWait());
        this.setClientId("Sender");
        this.sendAndCommit("INPUT MESSAGE");
        this.setClientId("Client1");
        Message output = this.receiveAndCommit();
        this.assertPayloadEquals("INPUT MESSAGE", output);
        JmsDurableTopicSingleTxTestCase.assertNull((Object)this.receiveNoWait());
        this.setClientId("Client2");
        this.receiveAndRollback();
        this.assertPayloadEquals("INPUT MESSAGE", output);
        output = this.receiveAndCommit();
        this.assertPayloadEquals("INPUT MESSAGE", output);
        JmsDurableTopicSingleTxTestCase.assertNull((Object)this.receiveNoWait());
    }
}

