/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.junit.Test;
import org.mule.message.ExceptionMessage;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public class JmsExceptionStrategyTestCase
extends AbstractJmsFunctionalTestCase {
    public JmsExceptionStrategyTestCase(JmsVendorConfiguration config) {
        super(config);
        this.setTransacted(true);
    }

    protected String getConfigResources() {
        return "integration/jms-exception-strategy.xml";
    }

    @Test
    public void testTransactedRedeliveryToDLDestination() throws Exception {
        this.sendAndCommit("INPUT MESSAGE");
        this.receiveAndAssertNone();
        Message output = this.receive(this.getJmsConfig().getDeadLetterDestinationName(), this.getTimeout(), null);
        JmsExceptionStrategyTestCase.assertTrue((String)("Message should be ObjectMessage but is " + output.getClass()), (boolean)(output instanceof ObjectMessage));
        Serializable payload = ((ObjectMessage)output).getObject();
        JmsExceptionStrategyTestCase.assertTrue((boolean)(payload instanceof ExceptionMessage));
        JmsExceptionStrategyTestCase.assertEquals((Object)"INPUT MESSAGE", (Object)((ExceptionMessage)payload).getPayload());
        String dest = output.getStringProperty("MULE_ENDPOINT");
        JmsExceptionStrategyTestCase.assertNotNull((Object)dest);
        JmsExceptionStrategyTestCase.assertEquals((String)this.getJmsConfig().getDeadLetterEndpoint(), (String)dest);
    }

    @Test
    public void testTransactedRedeliveryToDLDestinationRollback() throws Exception {
        this.sendAndCommit("INPUT MESSAGE");
        this.receive(this.getJmsConfig().getDeadLetterDestinationName(), this.getTimeout(), new AbstractJmsFunctionalTestCase.MessagePostProcessor(){

            public void postProcess(Session session, Message message) throws JMSException {
                session.rollback();
            }
        });
        this.receive(this.getJmsConfig().getDeadLetterDestinationName(), this.getTimeout(), new AbstractJmsFunctionalTestCase.MessagePostProcessor(){

            public void postProcess(Session session, Message message) throws JMSException {
                session.commit();
            }
        });
        Message output = this.receive(this.getJmsConfig().getDeadLetterDestinationName(), this.getSmallTimeout(), null);
        JmsExceptionStrategyTestCase.assertNull((Object)output);
    }
}

