/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.awt.Color;
import javax.jms.Message;
import org.junit.Test;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public class JmsQueueMessageTypesTestCase
extends AbstractJmsFunctionalTestCase {
    public JmsQueueMessageTypesTestCase(JmsVendorConfiguration config) {
        super(config);
    }

    protected String getConfigResources() {
        return "integration/jms-queue-message-types.xml";
    }

    @Test
    public void testTextMessage() throws Exception {
        this.send("TEST MESSAGE");
        Message output = this.receive();
        this.assertPayloadEquals("TEST MESSAGE", output);
        JmsQueueMessageTypesTestCase.assertNull((Object)this.receiveNoWait());
    }

    @Test
    public void testNumberMessage() throws Exception {
        this.send(25.75);
        Message output = this.receive();
        this.assertPayloadEquals(25.75, output);
        JmsQueueMessageTypesTestCase.assertNull((Object)this.receiveNoWait());
    }

    @Test
    public void testBinaryMessage() throws Exception {
        byte[] bytes = new byte[]{0, 127, 51, 127, 85};
        this.send(bytes);
        Message output = this.receive();
        this.assertPayloadEquals(bytes, output);
        JmsQueueMessageTypesTestCase.assertNull((Object)this.receiveNoWait());
    }

    @Test
    public void testJdkObjectMessage() throws Exception {
        Color obj = new Color(0);
        this.send(obj);
        Message output = this.receive();
        this.assertPayloadEquals(obj, output);
        JmsQueueMessageTypesTestCase.assertNull((Object)this.receiveNoWait());
    }

    @Test
    public void testCustomObjectMessage() throws Exception {
        Apple obj = new Apple();
        this.send(obj);
        Message output = this.receive();
        this.assertPayloadEquals(obj, output);
        JmsQueueMessageTypesTestCase.assertNull((Object)this.receiveNoWait());
    }
}

