/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.Test;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;
import org.mule.transport.jms.integration.SessionEnabledObjectToJMSMessage;
import org.mule.transport.jms.transformers.AbstractJmsTransformer;
import org.mule.transport.jms.transformers.JMSMessageToObject;
import org.mule.util.FileUtils;
import org.mule.util.compression.GZipCompression;

public class JmsTransformersTestCase
extends AbstractJmsFunctionalTestCase {
    private Session session = null;

    public JmsTransformersTestCase(JmsVendorConfiguration config) {
        super(config);
    }

    protected String getConfigResources() {
        return "integration/jms-transformers.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = this.getConnection(false, false).createSession(false, 1);
    }

    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Test
    public void testTransformObjectMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        ObjectMessage oMsg = this.session.createObjectMessage();
        File f = FileUtils.newFile((String)"/some/random/path");
        oMsg.setObject((Serializable)f);
        AbstractJmsTransformer trans = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        Object result = trans.transform((Object)oMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a File", (boolean)result.getClass().equals(File.class));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        trans2.setReturnClass(ObjectMessage.class);
        this.initialiseObject((Object)trans2);
        Object result2 = trans2.transform(f);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be an object message", (boolean)(result2 instanceof ObjectMessage));
    }

    @Test
    public void testTransformTextMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        String text = "This is a test TextMessage";
        TextMessage tMsg = this.session.createTextMessage();
        tMsg.setText(text);
        AbstractJmsTransformer trans = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        Object result = trans.transform((Object)tMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a string", (boolean)text.equals(result.toString()));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        trans2.setReturnClass(TextMessage.class);
        this.initialiseObject((Object)trans2);
        Object result2 = trans2.transform(text);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a TextMessage", (boolean)(result2 instanceof TextMessage));
    }

    @Test
    public void testTransformMapMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("Key1", "Value1");
        p.put("Key2", new byte[]{1, 2, 3});
        p.put("Key3", new Double(99.999));
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnClass(MapMessage.class);
        this.initialiseObject((Object)trans);
        Object result2 = trans.transform(p);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a MapMessage", (boolean)(result2 instanceof MapMessage));
        MapMessage mMsg = (MapMessage)result2;
        AbstractJmsTransformer trans2 = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        trans2.setReturnClass(Map.class);
        Object result = trans2.transform((Object)mMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a Map", (boolean)(result instanceof Map));
        Map m = (Map)result;
        JmsTransformersTestCase.assertEquals((Object)"Value1", m.get("Key1"));
        JmsTransformersTestCase.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, (byte[])m.get("Key2")));
        JmsTransformersTestCase.assertEquals((Object)new Double(99.999), m.get("Key3"));
    }

    @Test
    public void testTransformMapToObjectMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("Key1", "Value1");
        p.put("Key2", new byte[]{1, 2, 3});
        p.put("Key3", new Double(99.999));
        p.put("Key4", new Orange());
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnClass(ObjectMessage.class);
        this.initialiseObject((Object)trans);
        Object result2 = trans.transform(p);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a ObjectMessage", (boolean)(result2 instanceof ObjectMessage));
        ObjectMessage oMsg = (ObjectMessage)result2;
        AbstractJmsTransformer trans2 = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        trans2.setReturnClass(Map.class);
        Object result = trans2.transform((Object)oMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a Map", (boolean)(result instanceof Map));
        Map m = (Map)result;
        JmsTransformersTestCase.assertEquals((Object)"Value1", m.get("Key1"));
        JmsTransformersTestCase.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, (byte[])m.get("Key2")));
        JmsTransformersTestCase.assertEquals((Object)new Double(99.999), m.get("Key3"));
        JmsTransformersTestCase.assertEquals((Object)new Orange(), m.get("Key4"));
    }

    @Test
    public void testTransformByteMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnClass(BytesMessage.class);
        this.initialiseObject((Object)trans);
        String text = "This is a test BytesMessage";
        Object result2 = trans.transform(text.getBytes());
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a BytesMessage", (boolean)(result2 instanceof BytesMessage));
        AbstractJmsTransformer trans2 = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        trans2.setReturnClass(byte[].class);
        BytesMessage bMsg = (BytesMessage)result2;
        Object result = trans2.transform((Object)bMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a byte[]", (boolean)(result instanceof byte[]));
        String res = new String((byte[])result);
        JmsTransformersTestCase.assertEquals((String)"Source and result should be equal", (String)text, (String)res);
    }

    @Test
    public void testTransformStreamMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        String text = "Test Text";
        int i = 97823;
        double d = 9.232143E126;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(i));
        list.add(new Double(d));
        list.add(text);
        StreamMessage message = this.session.createStreamMessage();
        message.writeString(text);
        message.writeInt(i);
        message.writeDouble(d);
        message.reset();
        AbstractJmsTransformer trans = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        Object transformedObject = trans.transform((Object)message);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a List", (boolean)(transformedObject instanceof List));
        List result = (List)transformedObject;
        String newText = (String)result.get(0);
        Integer newI = (Integer)result.get(1);
        Double newD = (Double)result.get(2);
        JmsTransformersTestCase.assertEquals((int)i, (int)newI);
        JmsTransformersTestCase.assertEquals((Object)new Double(d), (Object)newD);
        JmsTransformersTestCase.assertEquals((String)text, (String)newText);
    }

    @Test
    public void testCompressedBytesMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        GZipCompression compressor = new GZipCompression();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        byte[] originalBytes = baos.toByteArray();
        byte[] compressedBytes = compressor.compressByteArray(originalBytes);
        JmsTransformersTestCase.assertTrue((String)"Source compressedBytes should be compressed", (boolean)compressor.isCompressed(compressedBytes));
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnClass(BytesMessage.class);
        this.initialiseObject((Object)trans);
        Object result2 = trans.transform(compressedBytes);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a Bytes message", (boolean)(result2 instanceof BytesMessage));
        BytesMessage intermediate = (BytesMessage)result2;
        intermediate.reset();
        byte[] intermediateBytes = new byte[(int)intermediate.getBodyLength()];
        int intermediateSize = intermediate.readBytes(intermediateBytes);
        JmsTransformersTestCase.assertTrue((String)"Intermediate bytes must be compressed", (boolean)compressor.isCompressed(intermediateBytes));
        JmsTransformersTestCase.assertTrue((String)"Intermediate bytes must be equal to compressed source", (boolean)Arrays.equals(compressedBytes, intermediateBytes));
        JmsTransformersTestCase.assertEquals((String)"Intermediate bytes and compressed source must have same size", (int)compressedBytes.length, (int)intermediateSize);
        AbstractJmsTransformer trans2 = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        trans2.setReturnClass(byte[].class);
        BytesMessage bMsg = this.session.createBytesMessage();
        bMsg.writeBytes(compressedBytes);
        Object result = trans2.transform((Object)bMsg);
        JmsTransformersTestCase.assertTrue((String)"Transformed object should be a byte[]", (boolean)(result instanceof byte[]));
        JmsTransformersTestCase.assertTrue((String)"Result should be compressed", (boolean)compressor.isCompressed((byte[])result));
        JmsTransformersTestCase.assertTrue((String)"Source and result should be equal", (boolean)Arrays.equals(compressedBytes, (byte[])result));
    }
}

