/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.constraint.IsEqual;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.FullConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.Iterator;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.collections.IteratorUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.transport.jms.JmsMessageAdapter;
import org.mule.transport.jms.transformers.ObjectToJMSMessage;

public class JmsTransformerTestCase
extends AbstractMuleTestCase {
    public void testCustomJMSProperty() throws Exception {
        Mock mockMessage = new Mock(TextMessage.class);
        mockMessage.expectAndReturn("getJMSCorrelationID", null);
        mockMessage.expectAndReturn("getJMSMessageID", (Object)"1234567890");
        mockMessage.expectAndReturn("getJMSDeliveryMode", (Object)new Integer(1));
        mockMessage.expectAndReturn("getJMSDestination", null);
        mockMessage.expectAndReturn("getJMSPriority", (Object)new Integer(4));
        mockMessage.expectAndReturn("getJMSRedelivered", (Object)Boolean.FALSE);
        mockMessage.expectAndReturn("getJMSReplyTo", null);
        mockMessage.expectAndReturn("getJMSExpiration", (Object)new Long(0L));
        mockMessage.expectAndReturn("getJMSTimestamp", (Object)new Long(0L));
        mockMessage.expectAndReturn("getJMSType", null);
        mockMessage.expect("toString");
        mockMessage.expect("toString");
        mockMessage.expect("clearProperties");
        mockMessage.expectAndReturn("getPropertyNames", (Object)IteratorUtils.asEnumeration((Iterator)IteratorUtils.emptyIterator()));
        mockMessage.expectAndReturn("getObjectProperty", (Object)"JMS_CUSTOM_PROPERTY", (Object)"customValue");
        FullConstraintMatcher setPropertyMatcher = new FullConstraintMatcher(new Constraint[]{new IsEqual((Object)"JMS_CUSTOM_PROPERTY"), new IsEqual((Object)"customValue")});
        mockMessage.expect("setObjectProperty", (ConstraintMatcher)setPropertyMatcher);
        Message mockTextMessage = (Message)mockMessage.proxy();
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)new JmsMessageAdapter((Object)mockTextMessage), muleContext);
        msg.setProperty("JMS_CUSTOM_PROPERTY", (Object)"customValue");
        JmsTransformerTestCase.assertNotNull((String)"The test hasn't been configured properly, no muleContext available", (Object)muleContext);
        RequestContext.setEvent((MuleEvent)new DefaultMuleEvent((MuleMessage)msg, MuleTestUtils.getTestEvent((Object)"previous", (MuleContext)muleContext)));
        ObjectToJMSMessage transformer = (ObjectToJMSMessage)this.createObject(ObjectToJMSMessage.class);
        Message transformed = (Message)transformer.transform(msg.getPayload());
        JmsTransformerTestCase.assertEquals((Object)"customValue", (Object)transformed.getObjectProperty("JMS_CUSTOM_PROPERTY"));
    }
}

