/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.NullPayload;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public class JmsTemporaryReplyToTestCase
extends AbstractJmsFunctionalTestCase {
    public JmsTemporaryReplyToTestCase(JmsVendorConfiguration config) {
        super(config);
    }

    protected String getConfigResources() {
        return "integration/jms-temporary-replyTo.xml";
    }

    @Test
    public void testTemporaryReplyEnabledAsync() throws MuleException {
        MuleClient muleClient = new MuleClient();
        MuleMessage response = muleClient.send("vm://in1", (Object)"Test Message", null);
        JmsTemporaryReplyToTestCase.assertEquals((Object)"Test Message", (Object)response.getPayload());
    }

    @Test
    public void testTemporaryReplyEnabledSync() throws MuleException {
        MuleClient muleClient = new MuleClient();
        MuleMessage response = muleClient.send("vm://in1Sync", (Object)"Test Message", null);
        JmsTemporaryReplyToTestCase.assertEquals((Object)"Test Message TestService1", (Object)response.getPayload());
    }

    @Test
    public void testTemporaryReplyDisabledAsync() throws MuleException {
        MuleClient muleClient = new MuleClient();
        MuleMessage response = muleClient.send("vm://in2", (Object)"Test Message", null);
        JmsTemporaryReplyToTestCase.assertEquals((Object)"Test Message", (Object)response.getPayload());
    }

    @Test
    public void testTemporaryReplyDisabledSync() throws MuleException {
        MuleClient muleClient = new MuleClient();
        MuleMessage response = muleClient.send("vm://in2Sync", (Object)"Test Message", null);
        JmsTemporaryReplyToTestCase.assertEquals((Object)"Test Message", (Object)response.getPayload());
    }

    @Test
    public void testDisableTemporaryReplyOnTheConnector() throws MuleException {
        MuleClient muleClient = new MuleClient();
        MuleMessage response = muleClient.send("vm://in3", (Object)"Test Message", null);
        JmsTemporaryReplyToTestCase.assertEquals((Object)NullPayload.getInstance(), (Object)response.getPayload());
    }

    @Test
    public void testExplicitReplyToAsyncSet() throws MuleException {
        MuleClient muleClient = new MuleClient();
        MuleMessage response = muleClient.send("vm://in4", (Object)"Test Message", null);
        JmsTemporaryReplyToTestCase.assertEquals((Object)"Test Message TestService1", (Object)response.getPayload());
    }
}

