/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.context.notification.TransactionNotificationListener;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.context.notification.TransactionNotification;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.util.StringUtils;

public class JmsMessageRequester
extends AbstractMessageRequester {
    private JmsConnector connector;

    public JmsMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (JmsConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MuleMessage doRequest(long timeout) throws Exception {
        Session session = null;
        MessageConsumer consumer = null;
        boolean cleanupListenerRegistered = false;
        try {
            Message message;
            block13: {
                MuleMessage muleMessage;
                String durableName;
                String expressionTemplate;
                boolean topic = this.connector.getTopicResolver().isTopic(this.endpoint);
                JmsSupport support = this.connector.getJmsSupport();
                TransactionConfig transactionConfig = this.endpoint.getTransactionConfig();
                final Transaction tx = TransactionCoordination.getInstance().getTransaction();
                boolean transacted = transactionConfig != null && transactionConfig.isTransacted();
                session = this.connector.getSession(transacted, topic);
                if (transacted && !tx.isXA()) {
                    final Session finalSession = session;
                    this.getConnector().getMuleContext().registerListener((ServerNotificationListener)new TransactionNotificationListener<TransactionNotification>(){

                        public void onNotification(TransactionNotification txNotification) {
                            int txAction = txNotification.getAction();
                            String txId = txNotification.getTransactionStringId();
                            if ((txAction == 1202 || txAction == 1203) && txId.equals(tx.getId())) {
                                JmsMessageRequester.this.connector.closeQuietly(finalSession);
                            }
                        }
                    }, tx.getId());
                    cleanupListenerRegistered = true;
                }
                Destination dest = support.createDestination(session, this.endpoint);
                String selector = null;
                if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                    expressionTemplate = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
                    if (StringUtils.isNotBlank((String)expressionTemplate)) {
                        selector = this.connector.getMuleContext().getExpressionManager().parse(expressionTemplate, null);
                    }
                } else if (this.endpoint.getProperties() != null && StringUtils.isNotBlank((String)(expressionTemplate = (String)this.endpoint.getProperty((Object)"selector")))) {
                    selector = this.connector.getMuleContext().getExpressionManager().parse(expressionTemplate, null);
                }
                String tempDurable = (String)this.endpoint.getProperties().get("durable");
                boolean durable = this.connector.isDurable();
                if (tempDurable != null) {
                    durable = Boolean.valueOf(tempDurable);
                }
                if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && topic) {
                    durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
                    }
                }
                consumer = support.createConsumer(session, dest, selector, this.connector.isNoLocal(), durableName, topic, this.endpoint);
                try {
                    message = timeout == -1L ? consumer.receiveNoWait() : (timeout == 0L ? consumer.receive() : consumer.receive(timeout));
                    if (message != null) break block13;
                    muleMessage = null;
                }
                catch (Exception e) {
                    this.connector.handleException(e);
                    MuleMessage muleMessage2 = null;
                    Object var19_22 = null;
                    if (cleanupListenerRegistered) return muleMessage2;
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    return muleMessage2;
                }
                Object var19_20 = null;
                if (cleanupListenerRegistered) return muleMessage;
                this.connector.closeQuietly(consumer);
                this.connector.closeQuietly(session);
                return muleMessage;
            }
            message = this.connector.preProcessMessage(message, session);
            DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage((Object)this.connector.getMessageAdapter(message), this.connector.getMuleContext());
            Object var19_21 = null;
            if (cleanupListenerRegistered) return defaultMuleMessage;
            this.connector.closeQuietly(consumer);
            this.connector.closeQuietly(session);
            return defaultMuleMessage;
        }
        catch (Throwable throwable2) {
            Object var19_23 = null;
            if (cleanupListenerRegistered) throw throwable2;
            this.connector.closeQuietly(consumer);
            this.connector.closeQuietly(session);
            throw throwable2;
        }
    }

    protected void doDispose() {
    }
}

