/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import com.mockobjects.dynamic.Mock;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.jms.DefaultJmsTopicResolver;
import org.mule.transport.jms.JmsConnector;

public class DefaultJmsTopicResolverTestCase
extends FunctionalTestCase {
    private JmsConnector connector;
    private DefaultJmsTopicResolver resolver;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.connector = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        this.resolver = (DefaultJmsTopicResolver)this.connector.getTopicResolver();
    }

    protected String getConfigResources() {
        return "jms-topic-resolver.xml";
    }

    public void testSameConnector() {
        DefaultJmsTopicResolverTestCase.assertSame((Object)this.connector, (Object)this.resolver.getConnector());
    }

    public void testEndpointNotTopicWithFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep1");
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    public void testEndpointNotTopicWithFallback2() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep1");
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, true));
    }

    public void testEndpointNotTopicNoFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep1");
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, false));
    }

    public void testEndpointTopicPropertyWithFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep2");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    public void testEndpointTopicPropertyWithFallback2() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep2");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, true));
    }

    public void testEndpointTopicPropertyNoFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep2");
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, false));
    }

    public void testEndpointTopicPrefixWithFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep3");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    public void testEndpointTopicPrefixWithFallback2() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep3");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, true));
    }

    public void testEndpointTopicPrefixNoFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep3");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, false));
    }

    public void testEndpointTopicPrefixAndPropertyWithFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep4");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    public void testEndpointTopicPrefixAndPropertyWithFallback2() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep4");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, true));
    }

    public void testEndpointTopicPrefixAndPropertyNoFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep4");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, false));
    }

    public void testEndpointTopicUsesEndpointProperties() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep5");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    public void testEndpointTopicWithLeadingSlash() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep6");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    public void testEndpointTopicWithSlashes() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep7");
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    public void testEndpointQueueWithSlashes() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("ep8");
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    public void testDestinationNotTopic() throws Exception {
        Mock mock = new Mock(Queue.class);
        Queue queue = (Queue)mock.proxy();
        DefaultJmsTopicResolverTestCase.assertFalse((boolean)this.resolver.isTopic((Destination)queue));
        mock.verify();
    }

    public void testDestinationTopic() throws Exception {
        Mock mock = new Mock(Topic.class);
        Topic topic = (Topic)mock.proxy();
        DefaultJmsTopicResolverTestCase.assertTrue((boolean)this.resolver.isTopic((Destination)topic));
        mock.verify();
    }
}

