/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.config;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.activemq.ActiveMQJmsConnector;
import org.mule.transport.jms.mulemq.MuleMQJmsConnector;
import org.mule.transport.jms.mulemq.MuleMQXAJmsConnector;
import org.mule.transport.jms.weblogic.WeblogicJmsConnector;
import org.mule.transport.jms.websphere.WebsphereJmsConnector;

public class JmsVendorNamespaceHandlerTestCase
extends FunctionalTestCase {
    public JmsVendorNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigResources() {
        return "jms-vendor-namespace-config.xml";
    }

    public void testActiveMqDefault() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("activeMqConnectorDefaults");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        ConnectionFactory cf = c.getConnectionFactory();
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(cf instanceof ActiveMQConnectionFactory));
        JmsVendorNamespaceHandlerTestCase.assertEquals((String)"vm://localhost?broker.persistent=false&broker.useJmx=false", (String)((ActiveMQConnectionFactory)cf).getBrokerURL());
    }

    public void testActiveMqBrokerURL() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("activeMqConnectorBroker");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c.getConnectionFactory());
        ConnectionFactory cf = c.getConnectionFactory();
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(cf instanceof ActiveMQConnectionFactory));
        JmsVendorNamespaceHandlerTestCase.assertEquals((String)"tcp://localhost:1234", (String)((ActiveMQConnectionFactory)cf).getBrokerURL());
    }

    public void testWeblogicDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("weblogicConnector");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof WeblogicJmsConnector));
    }

    public void testWebsphereDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("websphereConnector");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof WebsphereJmsConnector));
    }

    public void testMuleMQDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("muleMqConnector");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof MuleMQJmsConnector));
        JmsVendorNamespaceHandlerTestCase.assertEquals((String)"nsp://localhost:9000", (String)((MuleMQJmsConnector)c).getRealmURL());
        JmsVendorNamespaceHandlerTestCase.assertEquals((String)"1.1", (String)((MuleMQJmsConnector)c).getSpecification());
    }

    public void testMuleMQBrokerURL() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("muleMqConnectorBroker");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof MuleMQJmsConnector));
        JmsVendorNamespaceHandlerTestCase.assertEquals((String)"nsp://localhost:1234", (String)((MuleMQJmsConnector)c).getRealmURL());
    }

    public void testMuleMQXaDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("muleMqXaConnector");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof MuleMQXAJmsConnector));
        JmsVendorNamespaceHandlerTestCase.assertEquals((String)"nsp://localhost:9000", (String)((MuleMQXAJmsConnector)c).getRealmURL());
    }

    public void testMuleMQXaBrokerURL() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("muleMqXaConnectorBroker");
        JmsVendorNamespaceHandlerTestCase.assertNotNull((Object)c);
        JmsVendorNamespaceHandlerTestCase.assertTrue((boolean)(c instanceof MuleMQXAJmsConnector));
        JmsVendorNamespaceHandlerTestCase.assertEquals((String)"nsp://localhost:1234", (String)((MuleMQJmsConnector)c).getRealmURL());
    }
}

