/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.MuleParameterized;
import org.mule.transport.jms.JmsMessageUtils;
import org.mule.transport.jms.integration.JmsVendorConfiguration;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

@RunWith(value=MuleParameterized.class)
public abstract class AbstractJmsFunctionalTestCase
extends FunctionalTestCase {
    public static final String CONNECTOR = "jmsConnector";
    public static final String DEFAULT_INPUT_MESSAGE = "INPUT MESSAGE";
    public static final String DEFAULT_OUTPUT_MESSAGE = "OUTPUT MESSAGE";
    public static final String INBOUND_ENDPOINT_KEY = "inbound.destination";
    public static final String OUTBOUND_ENDPOINT_KEY = "outbound.destination";
    public static final String MIDDLE_ENDPOINT_KEY = "middle.destination";
    public static final String MIDDLE2_ENDPOINT_KEY = "middle2.destination";
    public static final String MIDDLE3_ENDPOINT_KEY = "middle3.destination";
    public static final String BROADCAST_TOPIC_ENDPOINT_KEY = "broadcast.topic.destination";
    protected static final Log logger = LogFactory.getLog((String)"MULE_TESTS");
    protected JmsVendorConfiguration jmsConfig = null;
    private boolean multipleProviders = true;
    private boolean transacted = false;
    private boolean persistent = false;
    private int acknowledgeMode = 1;
    private String jmsSpecification = "1.0.2b";
    private String clientId;
    private boolean useTopics = false;
    private MuleClient client = null;

    @Parameterized.Parameters
    public static Collection jmsProviderConfigs() {
        URL url = ClassUtils.getResource((String)"jms-vendor-configs.txt", AbstractJmsFunctionalTestCase.class);
        if (url == null) {
            AbstractJmsFunctionalTestCase.fail((String)"Please specify the org.mule.transport.jms.integration.JmsVendorConfiguration implementation to use in jms-vendor-configs.txt on classpaath.");
            return CollectionUtils.EMPTY_COLLECTION;
        }
        try {
            ArrayList<Object[]> configs = new ArrayList<Object[]>();
            List classes = IOUtils.readLines((InputStream)url.openStream());
            int i = 0;
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                String cls = ((String)iterator.next()).trim();
                if (!cls.startsWith("#")) {
                    configs.add(new Object[]{ClassUtils.instanciateClass((String)cls, (Object[])ClassUtils.NO_ARGS)});
                }
                ++i;
            }
            return configs;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            AbstractJmsFunctionalTestCase.fail((String)("Please specify the org.mule.transport.jms.integration.JmsVendorConfiguration implementation to use in jms-vendor-configs.txt on classpath: " + e.getMessage()));
            return CollectionUtils.EMPTY_COLLECTION;
        }
    }

    @Before
    public void before() throws Exception {
        super.setUp();
    }

    @After
    public void after() throws Exception {
        this.purge(this.getJmsConfig().getInboundDestinationName());
        this.purge(this.getJmsConfig().getInboundDestinationName() + "1");
        this.purge(this.getJmsConfig().getInboundDestinationName() + "2");
        this.purge(this.getJmsConfig().getInboundDestinationName() + "3");
        this.purge(this.getJmsConfig().getOutboundDestinationName());
        this.purge(this.getJmsConfig().getOutboundDestinationName() + "1");
        this.purge(this.getJmsConfig().getOutboundDestinationName() + "2");
        this.purge(this.getJmsConfig().getOutboundDestinationName() + "3");
        this.purge(this.getJmsConfig().getMiddleDestinationName());
        this.purge(this.getJmsConfig().getMiddleDestinationName() + "2");
        this.purge(this.getJmsConfig().getMiddleDestinationName() + "3");
        this.purge(this.getJmsConfig().getDeadLetterDestinationName());
        this.purgeTopics();
        super.tearDown();
    }

    public AbstractJmsFunctionalTestCase(JmsVendorConfiguration config) {
        try {
            config.initialise(((Object)((Object)this)).getClass());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setJmsConfig(config);
        System.out.print("\n===== Parameterized test using: " + config.getName() + " =====");
    }

    protected Properties getStartUpProperties() {
        Properties props = new Properties();
        props.put(INBOUND_ENDPOINT_KEY, this.getJmsConfig().getInboundEndpoint());
        props.put(OUTBOUND_ENDPOINT_KEY, this.getJmsConfig().getOutboundEndpoint());
        props.put(MIDDLE_ENDPOINT_KEY, this.getJmsConfig().getMiddleEndpoint());
        props.put(MIDDLE2_ENDPOINT_KEY, this.getJmsConfig().getMiddleEndpoint() + "2");
        props.put(MIDDLE3_ENDPOINT_KEY, this.getJmsConfig().getMiddleEndpoint() + "3");
        props.put(BROADCAST_TOPIC_ENDPOINT_KEY, this.getJmsConfig().getTopicBroadcastEndpoint());
        props.put("protocol", this.getJmsConfig().getProtocol());
        Map p = this.getJmsConfig().getProperties();
        if (p != null) {
            props.putAll((Map<?, ?>)p);
        }
        return props;
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        if (this.multipleProviders) {
            String configResource = this.getConfigResources();
            if (StringUtils.splitAndTrim((String)configResource, (String)",; ").length > 1) {
                throw new IllegalArgumentException("Parameterized tests don't support multiple config files as input: " + configResource);
            }
            String resources = configResource.substring(configResource.lastIndexOf("/") + 1);
            resources = String.format("integration/%s/connector-%s,%s", this.getJmsConfig().getName(), resources, this.getConfigResources());
            SpringXmlConfigurationBuilder builder = new SpringXmlConfigurationBuilder(resources);
            return builder;
        }
        return super.getBuilder();
    }

    public final JmsVendorConfiguration getJmsConfig() {
        if (this.jmsConfig == null) {
            this.jmsConfig = this.createJmsConfig();
        }
        return this.jmsConfig;
    }

    public final void setJmsConfig(JmsVendorConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected JmsVendorConfiguration createJmsConfig() {
        return null;
    }

    protected final Connection getConnection(boolean topic, boolean xa) throws Exception {
        this.checkConfig();
        return this.getJmsConfig().getConnection(topic, xa);
    }

    protected final String getInboundEndpoint() {
        this.checkConfig();
        return this.getJmsConfig().getInboundEndpoint();
    }

    protected final String getOutboundEndpoint() {
        this.checkConfig();
        return this.getJmsConfig().getOutboundEndpoint();
    }

    protected final long getSmallTimeout() {
        this.checkConfig();
        return this.getJmsConfig().getSmallTimeout();
    }

    protected final long getTimeout() {
        this.checkConfig();
        return this.getJmsConfig().getTimeout();
    }

    protected void checkConfig() {
        if (this.getJmsConfig() == null) {
            throw new IllegalStateException("There must be a Jms Vendor config set on this test");
        }
    }

    public Message send() throws Exception {
        return this.send(DEFAULT_INPUT_MESSAGE);
    }

    public Message send(Object payload) throws Exception {
        if (this.isTransacted()) {
            throw new IllegalStateException("This test case is using transactions, you must call either sendAndCommit() or sendAndRollback()");
        }
        return this.send(payload, null);
    }

    public Message sendAndCommit(Object payload) throws Exception {
        return this.send(payload, new MessagePostProcessor(){

            public void postProcess(Session session, Message message) throws JMSException {
                session.commit();
            }
        });
    }

    public Message sendAndRollback(Object payload) throws Exception {
        return this.send(payload, new MessagePostProcessor(){

            public void postProcess(Session session, Message message) throws JMSException {
                session.rollback();
            }
        });
    }

    protected Message send(Object payload, MessagePostProcessor postProcessor) throws Exception {
        if (this.isUseTopics()) {
            return this.send(this.getJmsConfig().getBroadcastDestinationName(), payload, postProcessor);
        }
        return this.send(this.getJmsConfig().getInboundDestinationName(), payload, postProcessor);
    }

    /*
     * Exception decompiling
     */
    protected Message send(String dest, Object payload, MessagePostProcessor postProcessor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Message createJmsMessage(Object payload, Session session) throws JMSException {
        return JmsMessageUtils.toMessage((Object)payload, (Session)session);
    }

    public Message receive() throws Exception {
        return this.receive(null);
    }

    public Message receive(MessagePostProcessor postProcessor) throws Exception {
        if (this.isTransacted()) {
            throw new IllegalStateException("This test case is using transactions, you must call either receiveAndCommit() or receiveAndRollback()");
        }
        return this.receive(this.getTimeout(), postProcessor);
    }

    public Message receiveNoWait() throws Exception {
        return this.receive(this.getSmallTimeout(), null);
    }

    public Message receiveAndCommit() throws Exception {
        return this.receive(this.getTimeout(), new MessagePostProcessor(){

            public void postProcess(Session session, Message message) throws JMSException {
                session.commit();
            }
        });
    }

    public Message receiveAndRollback() throws Exception {
        return this.receive(this.getTimeout(), new MessagePostProcessor(){

            public void postProcess(Session session, Message message) throws JMSException {
                session.rollback();
            }
        });
    }

    protected Message receive(long timeout, MessagePostProcessor postProcessor) throws Exception {
        if (this.isUseTopics()) {
            return this.receive(this.getJmsConfig().getBroadcastDestinationName(), timeout, postProcessor);
        }
        return this.receive(this.getJmsConfig().getOutboundDestinationName(), timeout, postProcessor);
    }

    /*
     * Exception decompiling
     */
    protected Message receive(String queue, long timeout, MessagePostProcessor postProcessor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purge(String destination) throws Exception {
        Connection c = null;
        Session s = null;
        try {
            logger.debug((Object)("purging queue : " + destination));
            c = this.getConnection(false, false);
            AbstractJmsFunctionalTestCase.assertNotNull((Object)c);
            c.start();
            s = c.createSession(false, 1);
            Queue d = s.createQueue(destination);
            MessageConsumer consumer = s.createConsumer((Destination)d);
            while (consumer.receiveNoWait() != null) {
                logger.debug((Object)("Destination " + destination + " isn't empty, draining it"));
            }
        }
        finally {
            if (c != null) {
                c.stop();
                if (s != null) {
                    s.close();
                }
                c.close();
            }
        }
    }

    protected void purgeTopics() throws Exception {
        String destination = "broadcast";
        this.purgeTopic(destination, "Client1");
        this.purgeTopic(destination, "Client2");
        this.purgeTopic(destination, "mule.JmsConnectorC1.broadcast");
        this.purgeTopic(destination, "mule.JmsConnectorC2.broadcast");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeTopic(String destination, String topic) throws Exception {
        TopicConnection c = null;
        TopicSession s = null;
        try {
            logger.debug((Object)("purging topic : " + topic));
            c = (TopicConnection)this.getConnection(true, false);
            if (c == null) {
                logger.debug((Object)("could not create a connection to topic : " + destination));
            }
            c.start();
            s = c.createTopicSession(true, 0);
            logger.debug((Object)"created topic session");
            Topic dest = s.createTopic(destination);
            logger.debug((Object)"created topic destination");
            TopicSubscriber consumer = null;
            try {
                consumer = s.createDurableSubscriber(dest, topic);
                logger.debug((Object)"created consumer");
                while (consumer.receiveNoWait() != null) {
                    logger.debug((Object)("Topic " + topic + " isn't empty, draining it"));
                }
                logger.debug((Object)"topic should be empty");
                consumer.close();
                s.unsubscribe(topic);
            }
            catch (JMSException e) {
                logger.debug((Object)("could not unsubscribe : " + topic));
            }
        }
        finally {
            if (c != null) {
                c.stop();
                if (s != null) {
                    s.close();
                }
                c.close();
            }
        }
        logger.debug((Object)("completed draining topic :" + topic));
    }

    protected void receiveAndAssertNone() throws Exception {
        AbstractJmsFunctionalTestCase.assertNull((Object)this.receiveNoWait());
    }

    protected void receiveAndAssert() throws Exception {
        this.assertPayloadEquals(DEFAULT_OUTPUT_MESSAGE, this.receive());
    }

    protected void assertPayloadEquals(Object expected, Message message) {
        AbstractJmsFunctionalTestCase.assertNotNull((String)"Message is null", (Object)message);
        Object object = null;
        try {
            object = JmsMessageUtils.toObject((Message)message, (String)this.getJmsSpecification(), (String)muleContext.getConfiguration().getDefaultEncoding());
        }
        catch (Exception e) {
            AbstractJmsFunctionalTestCase.fail((String)e.getMessage());
        }
        if (expected instanceof byte[]) {
            this.assertEquals((byte[])expected, (byte[])object);
        } else {
            AbstractJmsFunctionalTestCase.assertEquals((Object)expected, (Object)object);
        }
    }

    protected void assertEquals(byte[] expected, byte[] actual) {
        AbstractJmsFunctionalTestCase.assertEquals((String)"Wrong number of bytes", (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            AbstractJmsFunctionalTestCase.assertEquals((String)("Byte #" + i + " does not match"), (byte)expected[i], (byte)actual[i]);
        }
    }

    public boolean isMultipleProviders() {
        return this.multipleProviders;
    }

    public void setMultipleProviders(boolean multipleProviders) {
        this.multipleProviders = multipleProviders;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public String getJmsSpecification() {
        return this.jmsSpecification;
    }

    public void setJmsSpecification(String jmsSpecification) {
        this.jmsSpecification = jmsSpecification;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isUseTopics() {
        return this.useTopics;
    }

    public void setUseTopics(boolean useTopics) {
        this.useTopics = useTopics;
    }

    static interface MessagePostProcessor {
        public void postProcess(Session var1, Message var2) throws JMSException;
    }
}

