/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Test;
import org.mule.message.ExceptionMessage;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.JmsVendorConfiguration;

public class JmsExceptionStrategyTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String DEADLETTER_QUEUE_NAME = "dlq";

    public JmsExceptionStrategyTestCase(JmsVendorConfiguration config) {
        super(config);
        this.setTransacted(true);
    }

    protected String getConfigResources() {
        return "integration/jms-exception-strategy.xml";
    }

    @Test
    public void testTransactedRedeliveryToDLDestination() throws Exception {
        this.sendAndCommit("INPUT MESSAGE");
        this.receiveAndAssertNone();
        Message message = this.receive(this.getJmsConfig().getDeadLetterDestinationName(), this.getTimeout(), null);
        Object obj = null;
        if (message instanceof BytesMessage) {
            byte[] messageBytes = new byte[(int)((BytesMessage)message).getBodyLength()];
            ((BytesMessage)message).readBytes(messageBytes);
            obj = SerializationUtils.deserialize((byte[])messageBytes);
        } else if (message instanceof ObjectMessage) {
            obj = ((ObjectMessage)message).getObject();
        } else {
            JmsExceptionStrategyTestCase.fail((String)("Message is an unexpected type: " + message.getClass().getName()));
        }
        JmsExceptionStrategyTestCase.assertTrue((boolean)(obj instanceof ExceptionMessage));
        Object payload = ((ExceptionMessage)obj).getPayload();
        if (payload instanceof TextMessage) {
            JmsExceptionStrategyTestCase.assertEquals((String)"INPUT MESSAGE", (String)((TextMessage)payload).getText());
        } else if (payload instanceof String) {
            JmsExceptionStrategyTestCase.assertEquals((Object)"INPUT MESSAGE", (Object)payload);
        } else {
            JmsExceptionStrategyTestCase.fail((String)("Payload is an unexpected type: " + payload.getClass().getName()));
        }
        String dest = message.getStringProperty("MULE_ENDPOINT");
        if (dest != null) {
            JmsExceptionStrategyTestCase.assertEquals((String)this.getJmsConfig().getDeadLetterEndpoint(), (String)dest);
        }
    }

    @Test
    public void testTransactedRedeliveryToDLDestinationRollback() throws Exception {
        this.sendAndCommit("INPUT MESSAGE");
        this.receive(this.getJmsConfig().getDeadLetterDestinationName(), this.getTimeout(), new AbstractJmsFunctionalTestCase.MessagePostProcessor(){

            public void postProcess(Session session, Message message) throws JMSException {
                session.rollback();
            }
        });
        this.receive(this.getJmsConfig().getDeadLetterDestinationName(), this.getTimeout(), new AbstractJmsFunctionalTestCase.MessagePostProcessor(){

            public void postProcess(Session session, Message message) throws JMSException {
                session.commit();
            }
        });
        Message output = this.receive(this.getJmsConfig().getDeadLetterDestinationName(), this.getSmallTimeout(), null);
        JmsExceptionStrategyTestCase.assertNull((Object)output);
    }
}

