/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Closeable;
import org.apache.activemq.StreamConnection;
import org.apache.activemq.management.StatsCapable;
import org.apache.activemq.transport.TransportListener;
import org.mule.transport.jms.test.TestReconnectionConnectionFactoryWrapper;
import org.mule.transport.jms.xa.TargetInvocationHandler;

public class ActiveMQTestReconnectionConnectionFactoryWrapper
extends ActiveMQConnectionFactory
implements TargetInvocationHandler,
TestReconnectionConnectionFactoryWrapper {
    private static List calledMethods;
    private static volatile boolean enabled;
    private static Connection connection;

    public void init() {
        enabled = true;
        calledMethods = new CopyOnWriteArrayList();
    }

    public ActiveMQTestReconnectionConnectionFactoryWrapper() {
        this.init();
    }

    public ActiveMQTestReconnectionConnectionFactoryWrapper(String brokerURL) {
        super(brokerURL);
        this.init();
    }

    public ActiveMQTestReconnectionConnectionFactoryWrapper(URI brokerURL) {
        super(brokerURL);
        this.init();
    }

    public ActiveMQTestReconnectionConnectionFactoryWrapper(String userName, String password, URI brokerURL) {
        super(userName, password, brokerURL);
        this.init();
    }

    public ActiveMQTestReconnectionConnectionFactoryWrapper(String userName, String password, String brokerURL) {
        super(userName, password, brokerURL);
        this.init();
    }

    public QueueConnection createQueueConnection() throws JMSException {
        this.registration();
        connection = super.createQueueConnection();
        return (QueueConnection)Proxy.newProxyInstance(ActiveMQTestReconnectionConnectionFactoryWrapper.class.getClassLoader(), new Class[]{Connection.class, TopicConnection.class, QueueConnection.class, StatsCapable.class, Closeable.class, StreamConnection.class, TransportListener.class}, (InvocationHandler)((Object)this));
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        this.registration();
        connection = super.createQueueConnection(userName, password);
        return (QueueConnection)Proxy.newProxyInstance(ActiveMQTestReconnectionConnectionFactoryWrapper.class.getClassLoader(), new Class[]{Connection.class, TopicConnection.class, QueueConnection.class, StatsCapable.class, Closeable.class, StreamConnection.class, TransportListener.class}, (InvocationHandler)((Object)this));
    }

    public TopicConnection createTopicConnection() throws JMSException {
        this.registration();
        connection = super.createTopicConnection();
        return (TopicConnection)Proxy.newProxyInstance(ActiveMQTestReconnectionConnectionFactoryWrapper.class.getClassLoader(), new Class[]{Connection.class, TopicConnection.class, QueueConnection.class, StatsCapable.class, Closeable.class, StreamConnection.class, TransportListener.class}, (InvocationHandler)((Object)this));
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        this.registration();
        connection = super.createTopicConnection(userName, password);
        return (TopicConnection)Proxy.newProxyInstance(ActiveMQTestReconnectionConnectionFactoryWrapper.class.getClassLoader(), new Class[]{Connection.class, TopicConnection.class, QueueConnection.class, StatsCapable.class, Closeable.class, StreamConnection.class, TransportListener.class}, (InvocationHandler)((Object)this));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.registration();
        return method.invoke((Object)connection, args);
    }

    public Object getTargetObject() {
        return connection;
    }

    private void registration() throws JMSException {
        calledMethods.add(new Date());
        if (!this.isEnabled()) {
            if (connection.getExceptionListener() != null) {
                try {
                    connection.getExceptionListener().onException(new JMSException("Disabled"));
                }
                catch (Exception e) {
                    throw new JMSException("Disabled");
                }
            } else {
                throw new JMSException("Disabled");
            }
        }
    }

    public List getCalledMethods() {
        return calledMethods;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        ActiveMQTestReconnectionConnectionFactoryWrapper.enabled = enabled;
    }

    public void closeConnection() {
        try {
            connection.close();
        }
        catch (Exception e) {
            System.out.println("Error while closing connection: " + e.getMessage());
        }
    }

    static {
        enabled = true;
    }
}

