/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.XAConnectionFactory;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ExceptionReader;
import org.mule.api.context.notification.ConnectionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.StopException;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.NotificationException;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;
import org.mule.transport.jms.AutoDiscoveryRedeliveryHandlerFactory;
import org.mule.transport.jms.DefaultJmsTopicResolver;
import org.mule.transport.jms.Jms102bSupport;
import org.mule.transport.jms.Jms11Support;
import org.mule.transport.jms.JmsExceptionReader;
import org.mule.transport.jms.JmsReplyToHandler;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.JmsTopicResolver;
import org.mule.transport.jms.MultiConsumerJmsMessageReceiver;
import org.mule.transport.jms.RedeliveryHandlerFactory;
import org.mule.transport.jms.i18n.JmsMessages;
import org.mule.transport.jms.xa.ConnectionFactoryWrapper;
import org.mule.util.BeanUtils;

public class JmsConnector
extends AbstractConnector
implements ExceptionListener {
    public static final String JMS = "jms";
    public static final int REDELIVERY_FAIL_ON_FIRST = 0;
    public static final int REDELIVERY_IGNORE = -1;
    private AtomicInteger receiverReportedExceptionCount = new AtomicInteger();
    private int acknowledgementMode = 1;
    private String clientId;
    private boolean durable;
    private boolean noLocal;
    private boolean persistentDelivery;
    private boolean honorQosHeaders;
    private int maxRedelivery = 0;
    private boolean cacheJmsSessions = false;
    private boolean eagerConsumer = true;
    private Connection connection;
    private ConnectionFactory connectionFactory;
    private Map connectionFactoryProperties;
    public String username = null;
    public String password = null;
    private Context jndiContext = null;
    private final Object jndiLock = new Object();
    private String jndiProviderUrl;
    private String jndiInitialFactory;
    private Map jndiProviderProperties;
    private String connectionFactoryJndiName;
    private boolean jndiDestinations = false;
    private boolean forceJndiDestinations = false;
    private String specification = "1.0.2b";
    private JmsSupport jmsSupport;
    private JmsTopicResolver topicResolver;
    private RedeliveryHandlerFactory redeliveryHandlerFactory;
    private boolean disableTemporaryReplyToDestinations = false;
    private boolean returnOriginalMessageAsReply = false;
    private boolean embeddedMode;

    public JmsConnector(MuleContext context) {
        super(context);
    }

    public String getProtocol() {
        return JMS;
    }

    protected void doInitialise() throws InitialisationException {
        try {
            this.connectionFactory = this.createConnectionFactory();
        }
        catch (NamingException ne) {
            throw new InitialisationException(JmsMessages.errorCreatingConnectionFactory(), (Throwable)ne, (Initialisable)this);
        }
        if (this.connectionFactoryProperties != null && !this.connectionFactoryProperties.isEmpty()) {
            BeanUtils.populateWithoutFail((Object)this.connectionFactory, (Map)this.connectionFactoryProperties, (boolean)true);
        }
        if (this.topicResolver == null) {
            this.topicResolver = new DefaultJmsTopicResolver(this);
        }
        if (this.redeliveryHandlerFactory == null) {
            this.redeliveryHandlerFactory = new AutoDiscoveryRedeliveryHandlerFactory(this);
        }
        try {
            this.muleContext.registerListener((ServerNotificationListener)new ConnectionNotificationListener<ConnectionNotification>(){

                public void onNotification(ConnectionNotification notification) {
                    if (notification.getAction() == 703 || notification.getAction() == 702) {
                        JmsConnector.this.clearDispatchers();
                    }
                }
            }, this.getName());
        }
        catch (NotificationException nex) {
            throw new InitialisationException((Throwable)nex, (Initialisable)this);
        }
        if (this.jmsSupport == null) {
            this.jmsSupport = this.createJmsSupport();
        }
    }

    protected JmsSupport createJmsSupport() {
        Jms11Support result = "1.0.2b".equals(this.specification) ? new Jms102bSupport(this) : new Jms11Support(this);
        return result;
    }

    protected ConnectionFactory createConnectionFactory() throws InitialisationException, NamingException {
        if (this.jndiInitialFactory != null) {
            this.initJndiContext();
            Object temp = this.jndiContext.lookup(this.connectionFactoryJndiName);
            if (temp instanceof ConnectionFactory) {
                return (ConnectionFactory)temp;
            }
            throw new InitialisationException(JmsMessages.invalidResourceType(ConnectionFactory.class, temp), (Initialisable)this);
        }
        this.jndiDestinations = false;
        this.forceJndiDestinations = false;
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        ConnectionFactory factory = this.getDefaultConnectionFactory();
        if (factory != null) {
            return factory;
        }
        throw new InitialisationException(JmsMessages.noConnectionFactoryConfigured(), (Initialisable)this);
    }

    protected ConnectionFactory getDefaultConnectionFactory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.error((Object)"Jms connector failed to dispose properly: ", (Throwable)e);
            }
            this.connection = null;
        }
        if (this.jndiContext != null) {
            try {
                this.jndiContext.close();
            }
            catch (NamingException ne) {
                this.logger.error((Object)"Jms connector failed to dispose properly: ", (Throwable)ne);
            }
            finally {
                this.jndiContext = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initJndiContext() throws NamingException, InitialisationException {
        Object object = this.jndiLock;
        synchronized (object) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.jndiInitialFactory != null) {
                props.put("java.naming.factory.initial", this.jndiInitialFactory);
            } else if (this.jndiProviderProperties == null || !this.jndiProviderProperties.containsKey("java.naming.factory.initial")) {
                throw new InitialisationException(CoreMessages.objectIsNull((String)"jndiInitialFactory"), (Initialisable)this);
            }
            if (this.jndiProviderUrl != null) {
                props.put("java.naming.provider.url", this.jndiProviderUrl);
            }
            if (this.jndiProviderProperties != null) {
                props.putAll(this.jndiProviderProperties);
            }
            this.jndiContext = new InitialContext(props);
        }
    }

    protected Object lookupFromJndi(String jndiName) throws NamingException {
        Object object = this.jndiLock;
        synchronized (object) {
            try {
                return this.jndiContext.lookup(jndiName);
            }
            catch (CommunicationException ce) {
                try {
                    Transaction tx = TransactionCoordination.getInstance().getTransaction();
                    if (tx != null) {
                        tx.setRollbackOnly();
                    }
                }
                catch (TransactionException e) {
                    throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Failed to mark transaction for rollback: "), (Throwable)e);
                }
                throw ce;
            }
        }
    }

    protected Connection createConnection() throws NamingException, JMSException, InitialisationException {
        ConnectionFactory cf = this.connectionFactory;
        try {
            if (cf instanceof XAConnectionFactory && this.muleContext.getTransactionManager() != null) {
                cf = new ConnectionFactoryWrapper(cf);
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        Connection connection = this.username != null ? this.jmsSupport.createConnection(cf, this.username, this.password) : this.jmsSupport.createConnection(cf);
        if (connection != null) {
            if (this.clientId != null && !this.clientId.equals(connection.getClientID())) {
                connection.setClientID(this.getClientId());
            }
            if (!this.embeddedMode) {
                connection.setExceptionListener((ExceptionListener)this);
            }
        }
        return connection;
    }

    public void onException(JMSException jmsException) {
        int expectedReceiverCount;
        Map.Entry entry;
        JmsConnector jmsConnector = this;
        Map receivers = jmsConnector.getReceivers();
        boolean isMultiConsumerReceiver = false;
        if (!receivers.isEmpty() && (entry = receivers.entrySet().iterator().next()).getValue() instanceof MultiConsumerJmsMessageReceiver) {
            isMultiConsumerReceiver = true;
        }
        int n = expectedReceiverCount = isMultiConsumerReceiver ? 1 : jmsConnector.getReceivers().size() * jmsConnector.getNumberOfConcurrentTransactedReceivers();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("About to recycle myself due to remote JMS connection shutdown but need to wait for all active receivers to report connection loss. Receiver count: " + (this.receiverReportedExceptionCount.get() + 1) + '/' + expectedReceiverCount));
        }
        if (this.receiverReportedExceptionCount.incrementAndGet() >= expectedReceiverCount) {
            this.receiverReportedExceptionCount.set(0);
            this.handleException((Exception)new ConnectException((Throwable)jmsException, (Object)this));
        }
    }

    protected void doConnect() throws Exception {
        this.connection = this.createConnection();
        if (this.isStarted()) {
            this.connection.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws Exception {
        try {
            if (this.connection != null) {
                if (!this.embeddedMode) {
                    this.connection.setExceptionListener(null);
                }
                this.connection.close();
            }
        }
        finally {
            this.connection = null;
        }
    }

    protected Object getReceiverKey(Service service, InboundEndpoint endpoint) {
        return service.getName() + "~" + endpoint.getEndpointURI().getAddress();
    }

    public Session getSessionFromTransaction() {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.connection)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving jms session from current transaction " + tx));
            }
            Session session = (Session)tx.getResource((Object)this.connection);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using " + session + " bound to transaction " + tx));
            }
            return session;
        }
        return null;
    }

    public Session getSession(ImmutableEndpoint endpoint) throws JMSException {
        boolean topic = this.getTopicResolver().isTopic(endpoint);
        return this.getSession(endpoint.getTransactionConfig().isTransacted(), topic);
    }

    public Session getSession(boolean transacted, boolean topic) throws JMSException {
        Session session = this.getSessionFromTransaction();
        if (session != null) {
            return session;
        }
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        session = this.jmsSupport.createSession(this.connection, topic, transacted, this.acknowledgementMode, this.noLocal);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("Retrieved new jms session from connection: topic={0}, transacted={1}, ack mode={2}, nolocal={3}: {4}", topic, transacted, this.acknowledgementMode, this.noLocal, session));
        }
        if (tx != null) {
            this.logger.debug((Object)("Binding session " + session + " to current transaction " + tx));
            try {
                tx.bindResource((Object)this.connection, (Object)session);
            }
            catch (TransactionException e) {
                this.closeQuietly(session);
                throw new RuntimeException("Could not bind session to current transaction", e);
            }
        }
        return session;
    }

    protected void doStart() throws MuleException {
        if (this.connection != null) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                throw new StartException(CoreMessages.failedToStart((String)"Jms Connection"), (Throwable)e, (Startable)this);
            }
        }
    }

    protected void doStop() throws MuleException {
        if (this.connection != null) {
            try {
                this.connection.stop();
            }
            catch (JMSException e) {
                throw new StopException(CoreMessages.failedToStop((String)"Jms Connection"), (Throwable)e, (Stoppable)this);
            }
        }
    }

    public ReplyToHandler getReplyToHandler() {
        return new JmsReplyToHandler(this, this.getDefaultResponseTransformers());
    }

    public boolean supportsProperty(String property) {
        return true;
    }

    public Message preProcessMessage(Message message, Session session) throws Exception {
        return message;
    }

    public void close(MessageProducer producer) throws JMSException {
        if (producer != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing producer: " + producer));
            }
            producer.close();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Producer is null, nothing to close");
        }
    }

    public void closeQuietly(MessageProducer producer) {
        try {
            this.close(producer);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms message producer", (Throwable)e);
        }
    }

    public void close(MessageConsumer consumer) throws JMSException {
        if (consumer != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing consumer: " + consumer));
            }
            consumer.close();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Consumer is null, nothing to close");
        }
    }

    public void closeQuietly(MessageConsumer consumer) {
        try {
            this.close(consumer);
        }
        catch (JMSException e) {
            this.logger.error((Object)"Failed to close jms message consumer", (Throwable)e);
        }
    }

    public void close(Session session) throws JMSException {
        if (session != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing session " + session));
            }
            session.close();
        }
    }

    public void closeQuietly(Session session) {
        try {
            this.close(session);
        }
        catch (JMSException e) {
            this.logger.warn((Object)"Failed to close jms session consumer", (Throwable)e);
        }
    }

    public void close(TemporaryQueue tempQueue) throws JMSException {
        if (tempQueue != null) {
            tempQueue.delete();
        }
    }

    public void closeQuietly(TemporaryQueue tempQueue) {
        block4: {
            try {
                this.close(tempQueue);
            }
            catch (JMSException e) {
                if (!this.logger.isWarnEnabled()) break block4;
                String queueName = "";
                try {
                    queueName = tempQueue.getQueueName();
                }
                catch (JMSException innerEx) {
                    // empty catch block
                }
                this.logger.warn((Object)MessageFormat.format("Failed to delete a temporary queue ''{0}'' Reason: {1}", queueName, e.getMessage()));
            }
        }
    }

    public void close(TemporaryTopic tempTopic) throws JMSException {
        if (tempTopic != null) {
            tempTopic.delete();
        }
    }

    public void closeQuietly(TemporaryTopic tempTopic) {
        block4: {
            try {
                this.close(tempTopic);
            }
            catch (JMSException e) {
                if (!this.logger.isWarnEnabled()) break block4;
                String topicName = "";
                try {
                    topicName = tempTopic.getTopicName();
                }
                catch (JMSException innerEx) {
                    // empty catch block
                }
                this.logger.warn((Object)("Failed to delete a temporary topic " + topicName), (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isPersistentDelivery() {
        return this.persistentDelivery;
    }

    public void setPersistentDelivery(boolean persistentDelivery) {
        this.persistentDelivery = persistentDelivery;
    }

    public JmsSupport getJmsSupport() {
        return this.jmsSupport;
    }

    public void setJmsSupport(JmsSupport jmsSupport) {
        this.jmsSupport = jmsSupport;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        if (!"1.1".equals(specification) && !"1.0.2b".equals(specification)) {
            throw new IllegalArgumentException("JMS specification needs to be one of the defined values in JmsConstants but was: " + specification);
        }
        this.specification = specification;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getMaxRedelivery() {
        return this.maxRedelivery;
    }

    public void setMaxRedelivery(int maxRedelivery) {
        this.maxRedelivery = maxRedelivery;
    }

    public boolean isResponseEnabled() {
        return true;
    }

    public JmsTopicResolver getTopicResolver() {
        return this.topicResolver;
    }

    public void setTopicResolver(JmsTopicResolver topicResolver) {
        this.topicResolver = topicResolver;
    }

    public boolean isEagerConsumer() {
        return this.eagerConsumer;
    }

    public void setEagerConsumer(boolean eagerConsumer) {
        this.eagerConsumer = eagerConsumer;
    }

    public boolean isCacheJmsSessions() {
        return this.cacheJmsSessions;
    }

    public void setCacheJmsSessions(boolean cacheJmsSessions) {
        this.cacheJmsSessions = cacheJmsSessions;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public RedeliveryHandlerFactory getRedeliveryHandlerFactory() {
        return this.redeliveryHandlerFactory;
    }

    public void setRedeliveryHandlerFactory(RedeliveryHandlerFactory redeliveryHandlerFactory) {
        this.redeliveryHandlerFactory = redeliveryHandlerFactory;
    }

    public void setHonorQosHeaders(boolean honorQosHeaders) {
        this.honorQosHeaders = honorQosHeaders;
    }

    public boolean isHonorQosHeaders() {
        return this.honorQosHeaders;
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public void setJndiContext(Context jndiContext) {
        this.jndiContext = jndiContext;
    }

    public String getJndiInitialFactory() {
        return this.jndiInitialFactory;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.jndiInitialFactory = jndiInitialFactory;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public Map getJndiProviderProperties() {
        return this.jndiProviderProperties;
    }

    public void setJndiProviderProperties(Map jndiProviderProperties) {
        this.jndiProviderProperties = jndiProviderProperties;
    }

    public String getConnectionFactoryJndiName() {
        return this.connectionFactoryJndiName;
    }

    public void setConnectionFactoryJndiName(String connectionFactoryJndiName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
    }

    public boolean isJndiDestinations() {
        return this.jndiDestinations;
    }

    public void setJndiDestinations(boolean jndiDestinations) {
        this.jndiDestinations = jndiDestinations;
    }

    public boolean isForceJndiDestinations() {
        return this.forceJndiDestinations;
    }

    public void setForceJndiDestinations(boolean forceJndiDestinations) {
        this.forceJndiDestinations = forceJndiDestinations;
    }

    public boolean isDisableTemporaryReplyToDestinations() {
        return this.disableTemporaryReplyToDestinations;
    }

    public void setDisableTemporaryReplyToDestinations(boolean disableTemporaryReplyToDestinations) {
        this.disableTemporaryReplyToDestinations = disableTemporaryReplyToDestinations;
    }

    public boolean isReturnOriginalMessageAsReply() {
        return this.returnOriginalMessageAsReply;
    }

    public void setReturnOriginalMessageAsReply(boolean returnOriginalMessageAsReply) {
        this.returnOriginalMessageAsReply = returnOriginalMessageAsReply;
    }

    public Map getConnectionFactoryProperties() {
        return this.connectionFactoryProperties;
    }

    public void setConnectionFactoryProperties(Map connectionFactoryProperties) {
        this.connectionFactoryProperties = connectionFactoryProperties;
    }

    public void setNumberOfConsumers(int count) {
        this.numberOfConcurrentTransactedReceivers = count;
    }

    public int getNumberOfConsumers() {
        return this.numberOfConcurrentTransactedReceivers;
    }

    public boolean isEmbeddedMode() {
        return this.embeddedMode;
    }

    public void setEmbeddedMode(boolean embeddedMode) {
        this.embeddedMode = embeddedMode;
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new JmsExceptionReader());
    }
}

