/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.activemq;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.mule.api.MuleContext;
import org.mule.transport.ConnectException;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.xa.TargetInvocationHandler;
import org.mule.util.ClassUtils;

public class ActiveMQJmsConnector
extends JmsConnector {
    public static final String ACTIVEMQ_CONNECTION_FACTORY_CLASS = "org.apache.activemq.ActiveMQConnectionFactory";
    public static final String DEFAULT_BROKER_URL = "vm://localhost?broker.persistent=false&broker.useJmx=false";
    private String brokerURL = "vm://localhost?broker.persistent=false&broker.useJmx=false";

    public ActiveMQJmsConnector(MuleContext context) {
        super(context);
        this.setEagerConsumer(false);
    }

    protected ConnectionFactory getDefaultConnectionFactory() {
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)ClassUtils.instanciateClass((String)ACTIVEMQ_CONNECTION_FACTORY_CLASS, (Object[])new Object[]{this.getBrokerURL()});
            this.applyVendorSpecificConnectionFactoryProperties(connectionFactory);
            return connectionFactory;
        }
        catch (InvocationTargetException itex) {
            Throwable target = itex.getCause();
            this.handleException(target instanceof Exception ? (Exception)target : new Exception(target));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    protected void applyVendorSpecificConnectionFactoryProperties(ConnectionFactory connectionFactory) {
        try {
            Method getRedeliveryPolicyMethod = connectionFactory.getClass().getMethod("getRedeliveryPolicy", new Class[0]);
            Object redeliveryPolicy = getRedeliveryPolicyMethod.invoke((Object)connectionFactory, new Object[0]);
            Method setMaximumRedeliveriesMethod = redeliveryPolicy.getClass().getMethod("setMaximumRedeliveries", Integer.TYPE);
            setMaximumRedeliveriesMethod.invoke(redeliveryPolicy, this.getMaxRedelivery() + 1);
        }
        catch (Exception e) {
            this.logger.error((Object)("Can not set MaxRedelivery parameter to RedeliveryPolicy " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws ConnectException {
        try {
            Method cleanupMethod;
            Connection connection = this.getConnection();
            if (connection == null) {
                return;
            }
            Class<?> clazz = connection.getClass();
            if (Proxy.isProxyClass(clazz)) {
                TargetInvocationHandler handler = (TargetInvocationHandler)Proxy.getInvocationHandler(connection);
                connection = (Connection)handler.getTargetObject();
                Class<?> realConnectionClass = connection.getClass();
                cleanupMethod = realConnectionClass.getMethod("cleanup", null);
            } else {
                cleanupMethod = clazz.getMethod("cleanup", null);
            }
            try {
                if (cleanupMethod != null) {
                    cleanupMethod.invoke((Object)connection, (Object[])null);
                }
            }
            finally {
                connection.close();
            }
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
        finally {
            this.setConnection(null);
        }
    }

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }
}

