/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.mulemq;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.i18n.JmsMessages;
import org.mule.util.ClassUtils;

public class MuleMQJmsConnector
extends JmsConnector {
    public static final String MULEMQ_CONNECTION_FACTORY_CLASS = "com.pcbsys.nirvana.nJMS.ConnectionFactoryImpl";
    public static final String DEFAULT_REALM_URL = "nsp://localhost:9000";
    public static final String DEFAULT_BUFFER_OUTPUT = "queued";
    public static final boolean DEFAULT_SYNC_WRITES = false;
    public static final int DEFAULT_SYNC_BATCH_SIZE = 50;
    public static final int DEFAULT_SYNC_TIME = 20;
    public static final int DEFAULT_GLOBAL_STORE_CAPACITY = 5000;
    public static final int DEFAULT_MAX_UNACKED_SIZE = 100;
    public static final boolean DEFAULT_USE_JMS_ENGINE = true;
    public static final int DEFAULT_QUEUE_WINDOW_SIZE = 100;
    public static final int DEFAULT_AUTO_ACK_COUNT = 50;
    public static final boolean DEFAULT_ENABLE_SHARED_DURABLE = false;
    public static final boolean DEFAULT_RANDOMISE_R_NAMES = false;
    public static final int DEFAULT_MAX_REDELIVERY = 100;
    public static final int DEFAULT_MESSAGE_THREAD_POOL_SIZE = 30;
    public static final boolean DEFAULT_DISC_ON_CLUSTER_FAILURE = true;
    public static final int DEFAULT_INITIAL_RETRY_COUNT = 2;
    public static final boolean DEFAULT_RETRY_COMMIT = false;
    public static final boolean DEFAULT_ENABLE_MULTIPLEXED_CONNECTIONS = false;
    private String realmURL = "nsp://localhost:9000";
    private String bufferOutput = "queued";
    private boolean syncWrites = false;
    private int syncBatchSize = 50;
    private int syncTime = 20;
    private int globalStoreCapacity = 5000;
    private int maxUnackedSize = 100;
    private boolean useJMSEngine = true;
    private int queueWindowSize = 100;
    private int autoAckCount = 50;
    private boolean enableSharedDurable = false;
    private boolean randomiseRNames = false;
    private int muleMqMaxRedelivery = 100;
    private int messageThreadPoolSize = 30;
    private boolean discOnClusterFailure = true;
    private int initialRetryCount = 2;
    private boolean retryCommit = false;
    private boolean enableMultiplexedConnections = false;
    protected static final String BUFFER_OUTPUT = "BufferOutput";
    protected static final String SYNC_WRITES = "nirvana.syncWrites";
    protected static final String SYNC_BATCH_SIZE = "nirvana.syncBatchSize";
    protected static final String SYNC_TIME = "nirvana.syncTime";
    protected static final String GLOBAL_STORE_CAPACITY = "nirvana.globalStoreCapacity";
    protected static final String MAX_UNACKED_SIZE = "nirvana.maxUnackedSize";
    protected static final String USE_JMS_ENGINE = "nirvana.useJMSEngine";
    protected static final String QUEUE_WINDOW_SIZE = "nirvana.queueWindowSize";
    protected static final String AUTO_ACK_COUNT = "nirvana.autoAckCount";
    protected static final String ENABLE_SHARED_DURABLE = "nirvana.enableSharedDurable";
    protected static final String RANDOMISE_R_NAMES = "nirvana.randomiseRNames";
    protected static final String MAX_REDELIVERY = "nirvana.maxRedelivery";
    protected static final String MESSAGE_THREAD_POOL_SIZE = "nirvana.messageThreadPoolSize";
    protected static final String DISC_ON_CLUSTER_FAILURE = "nirvana.discOnClusterFailure";
    protected static final String INITIAL_RETRY_COUNT = "nirvana.initialRetryCount";
    protected static final String RETRY_COMMIT = "nirvana.retryCommit";
    protected static final String ENABLE_MULTIPLEXED_CONNECTIONS = "nirvana.enableMultiplexedConnections";
    public boolean supportJms102bSpec = false;

    public MuleMQJmsConnector(MuleContext context) {
        super(context);
        super.setSpecification("1.1");
    }

    public boolean isSupportJms102bSpec() {
        return this.supportJms102bSpec;
    }

    public void setSupportJms102bSpec(boolean supportJms102bSpec) {
        this.supportJms102bSpec = supportJms102bSpec;
    }

    public void setSpecification(String specification) {
        if (!this.isSupportJms102bSpec() && specification.equals("1.0.2b")) {
            this.logger.warn((Object)JmsMessages.errorMuleMqJmsSpecification());
            specification = "1.1";
        }
        super.setSpecification(specification);
    }

    protected void doInitialise() throws InitialisationException {
        if (!this.isSupportJms102bSpec() && this.getSpecification().equals("1.0.2b")) {
            throw new InitialisationException(JmsMessages.errorMuleMqJmsSpecification(), (Initialisable)this);
        }
        super.doInitialise();
    }

    protected ConnectionFactory getDefaultConnectionFactory() {
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)ClassUtils.instanciateClass((String)this.getMuleMQFactoryClass(), (Object[])new Object[]{this.getRealmURL()});
            this.applyVendorSpecificConnectionFactoryProperties(connectionFactory);
            return connectionFactory;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void applyVendorSpecificConnectionFactoryProperties(ConnectionFactory connectionFactory) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(BUFFER_OUTPUT, this.bufferOutput);
        props.put(SYNC_WRITES, Boolean.toString(this.syncWrites));
        props.put(SYNC_BATCH_SIZE, Integer.toString(this.syncBatchSize));
        props.put(SYNC_TIME, Integer.toString(this.syncTime));
        props.put(GLOBAL_STORE_CAPACITY, Integer.toString(this.globalStoreCapacity));
        props.put(MAX_UNACKED_SIZE, Integer.toString(this.maxUnackedSize));
        props.put(USE_JMS_ENGINE, Boolean.toString(this.useJMSEngine));
        props.put(QUEUE_WINDOW_SIZE, Integer.toString(this.queueWindowSize));
        props.put(AUTO_ACK_COUNT, Integer.toString(this.autoAckCount));
        props.put(ENABLE_SHARED_DURABLE, Boolean.toString(this.enableSharedDurable));
        props.put(RANDOMISE_R_NAMES, Boolean.toString(this.randomiseRNames));
        props.put(MAX_REDELIVERY, Integer.toString(this.muleMqMaxRedelivery));
        props.put(MESSAGE_THREAD_POOL_SIZE, Integer.toString(this.messageThreadPoolSize));
        props.put(DISC_ON_CLUSTER_FAILURE, Boolean.toString(this.discOnClusterFailure));
        props.put(INITIAL_RETRY_COUNT, Integer.toString(this.initialRetryCount));
        props.put(RETRY_COMMIT, Boolean.toString(this.retryCommit));
        props.put(ENABLE_MULTIPLEXED_CONNECTIONS, Boolean.toString(this.enableMultiplexedConnections));
        Map connectionFactoryProperties = this.getConnectionFactoryProperties();
        if (connectionFactoryProperties != null) {
            props.putAll(connectionFactoryProperties);
        }
        try {
            Method setPropertiesMethod = connectionFactory.getClass().getMethod("setProperties", Hashtable.class);
            setPropertiesMethod.invoke((Object)connectionFactory, props);
        }
        catch (Exception e) {
            this.logger.error((Object)("Can not set properties on the MuleMQ connection factory " + e));
        }
    }

    protected String getMuleMQFactoryClass() {
        return MULEMQ_CONNECTION_FACTORY_CLASS;
    }

    public String getRealmURL() {
        return this.realmURL;
    }

    public void setRealmURL(String realmURL) {
        this.realmURL = realmURL;
    }

    public String getBufferOutput() {
        return this.bufferOutput;
    }

    public void setBufferOutput(String bufferOutput) {
        this.bufferOutput = bufferOutput;
    }

    public boolean isSyncWrites() {
        return this.syncWrites;
    }

    public void setSyncWrites(boolean syncWrites) {
        this.syncWrites = syncWrites;
    }

    public int getSyncBatchSize() {
        return this.syncBatchSize;
    }

    public void setSyncBatchSize(int syncBatchSize) {
        this.syncBatchSize = syncBatchSize;
    }

    public int getSyncTime() {
        return this.syncTime;
    }

    public void setSyncTime(int syncTime) {
        this.syncTime = syncTime;
    }

    public int getGlobalStoreCapacity() {
        return this.globalStoreCapacity;
    }

    public void setGlobalStoreCapacity(int globalStoreCapacity) {
        this.globalStoreCapacity = globalStoreCapacity;
    }

    public int getMaxUnackedSize() {
        return this.maxUnackedSize;
    }

    public void setMaxUnackedSize(int maxUnackedSize) {
        this.maxUnackedSize = maxUnackedSize;
    }

    public boolean isUseJMSEngine() {
        return this.useJMSEngine;
    }

    public void setUseJMSEngine(boolean useJMSEngine) {
        this.useJMSEngine = useJMSEngine;
    }

    public int getQueueWindowSize() {
        return this.queueWindowSize;
    }

    public void setQueueWindowSize(int queueWindowSize) {
        this.queueWindowSize = queueWindowSize;
    }

    public int getAutoAckCount() {
        return this.autoAckCount;
    }

    public void setAutoAckCount(int autoAckCount) {
        this.autoAckCount = autoAckCount;
    }

    public boolean isEnableSharedDurable() {
        return this.enableSharedDurable;
    }

    public void setEnableSharedDurable(boolean enableSharedDurable) {
        this.enableSharedDurable = enableSharedDurable;
    }

    public boolean isRandomiseRNames() {
        return this.randomiseRNames;
    }

    public void setRandomiseRNames(boolean randomiseRNames) {
        this.randomiseRNames = randomiseRNames;
    }

    public int getMessageThreadPoolSize() {
        return this.messageThreadPoolSize;
    }

    public void setMessageThreadPoolSize(int messageThreadPoolSize) {
        this.messageThreadPoolSize = messageThreadPoolSize;
    }

    public boolean isDiscOnClusterFailure() {
        return this.discOnClusterFailure;
    }

    public void setDiscOnClusterFailure(boolean discOnClusterFailure) {
        this.discOnClusterFailure = discOnClusterFailure;
    }

    public int getInitialRetryCount() {
        return this.initialRetryCount;
    }

    public void setInitialRetryCount(int initialRetryCount) {
        this.initialRetryCount = initialRetryCount;
    }

    public int getMuleMqMaxRedelivery() {
        return this.muleMqMaxRedelivery;
    }

    public void setMuleMqMaxRedelivery(int mulqMqMaxRedelivery) {
        this.muleMqMaxRedelivery = mulqMqMaxRedelivery;
    }

    public void setRetryCommit(boolean retryCommit) {
        this.retryCommit = retryCommit;
    }

    public boolean isRetryCommit() {
        return this.retryCommit;
    }

    public boolean isEnableMultiplexedConnections() {
        return this.enableMultiplexedConnections;
    }

    public void setEnableMultiplexedConnections(boolean enableMultiplexedConnections) {
        this.enableMultiplexedConnections = enableMultiplexedConnections;
    }
}

