/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.transport.jms.AbstractRedeliveryHandler;
import org.mule.transport.jms.MessageRedeliveredException;
import org.mule.transport.jms.i18n.JmsMessages;

public class CountingRedeliveryHandler
extends AbstractRedeliveryHandler {
    protected static final Log logger = LogFactory.getLog(CountingRedeliveryHandler.class);
    private Map<String, Integer> messages = Collections.synchronizedMap(new LRUMap(256));

    public void handleRedelivery(Message message) throws JMSException, MuleException {
        int connectorRedelivery = this.connector.getMaxRedelivery();
        if (connectorRedelivery == -1 || connectorRedelivery < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"We were asked to ignore the redelivery count, nothing to do here.");
            }
            return;
        }
        String id = message.getJMSMessageID();
        if (id == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message doesn't have a JMSMessageID set, Mule can't handle redelivery for it. " + message));
            }
            return;
        }
        Integer redeliveryCount = this.messages.remove(id);
        if (redeliveryCount != null) {
            redeliveryCount = redeliveryCount + 1;
        }
        if (redeliveryCount == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered for the first time"));
            }
            this.messages.put(id, 1);
        } else if (redeliveryCount == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered for the first time"));
            }
            if (connectorRedelivery == 0) {
                MuleMessage msg = this.createMuleMessage(message);
                throw new MessageRedeliveredException(JmsMessages.tooManyRedeliveries(id, String.valueOf(redeliveryCount), connectorRedelivery, this.connector.getName()), msg);
            }
        } else {
            if (redeliveryCount > connectorRedelivery) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("Message with id: {0} has been redelivered {1} times, which exceeds the maxRedelivery setting of {2} on the connector {3}", id, redeliveryCount, connectorRedelivery, this.connector.getName()));
                }
                MuleMessage msg = this.createMuleMessage(message);
                throw new MessageRedeliveredException(JmsMessages.tooManyRedeliveries(id, "" + redeliveryCount, connectorRedelivery, this.connector.getName()), msg);
            }
            this.messages.put(id, redeliveryCount);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered " + redeliveryCount + " times"));
            }
        }
    }
}

