/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Session;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.transaction.Transaction;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;

public class JmsConnectorTestCase
extends AbstractMuleTestCase {
    private static final String CLIENT_ID1 = "client1";
    private static final String CLIENT_ID2 = "client2";

    public void testSetClientIDInConnectorForFirstTime() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getClientID()).thenReturn(null);
        JmsSupport jmsSupport = (JmsSupport)Mockito.mock(JmsSupport.class);
        Mockito.when((Object)jmsSupport.createConnection((ConnectionFactory)Matchers.any())).thenReturn((Object)connection);
        JmsConnector connector = new JmsConnector(muleContext);
        connector.setClientId(CLIENT_ID1);
        connector.setJmsSupport(jmsSupport);
        Connection createdConnection = connector.createConnection();
        JmsConnectorTestCase.assertEquals((Object)connection, (Object)createdConnection);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setClientID(Matchers.anyString());
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setClientID(CLIENT_ID1);
    }

    public void testSetClientIDInConnectorForSecondTime() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getClientID()).thenReturn((Object)CLIENT_ID1);
        JmsSupport jmsSupport = (JmsSupport)Mockito.mock(JmsSupport.class);
        Mockito.when((Object)jmsSupport.createConnection((ConnectionFactory)Matchers.any())).thenReturn((Object)connection);
        JmsConnector connector = new JmsConnector(muleContext);
        connector.setClientId(CLIENT_ID2);
        connector.setJmsSupport(jmsSupport);
        Connection createdConnection = connector.createConnection();
        JmsConnectorTestCase.assertEquals((Object)connection, (Object)createdConnection);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setClientID(Matchers.anyString());
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setClientID(CLIENT_ID2);
    }

    public void testSetClientIDInConnectionForFirstTime() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getClientID()).thenReturn((Object)CLIENT_ID1);
        JmsSupport jmsSupport = (JmsSupport)Mockito.mock(JmsSupport.class);
        Mockito.when((Object)jmsSupport.createConnection((ConnectionFactory)Matchers.any())).thenReturn((Object)connection);
        JmsConnector connector = new JmsConnector(muleContext);
        connector.setClientId(CLIENT_ID1);
        connector.setJmsSupport(jmsSupport);
        Connection createdConnection = connector.createConnection();
        JmsConnectorTestCase.assertEquals((Object)connection, (Object)createdConnection);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).setClientID(Matchers.anyString());
    }

    public void testClosesSessionIfThereIsNoActiveTransaction() throws Exception {
        JmsConnector connector = new JmsConnector(muleContext);
        Session session = (Session)Mockito.mock(Session.class);
        connector.closeSessionIfNoTransactionActive(session);
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoNotClosesSessionIfThereIsAnActiveTransaction() throws Exception {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        TransactionCoordination.getInstance().bindTransaction(transaction);
        try {
            JmsConnector connector = new JmsConnector(muleContext);
            Session session = (Session)Mockito.mock(Session.class);
            connector.closeSessionIfNoTransactionActive(session);
            ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).close();
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }
}

