/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.Iterator;
import javax.jms.TextMessage;
import org.apache.commons.collections.IteratorUtils;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.jms.JmsMuleMessageFactory;

public class JmsMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    private static final String MESSAGE_TEXT = "Test JMS Message";

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new JmsMuleMessageFactory(muleContext);
    }

    protected Object getValidTransportMessage() throws Exception {
        Mock message = new Mock(TextMessage.class);
        message.expectAndReturn("getText", (Object)MESSAGE_TEXT);
        message.expectAndReturn("getJMSCorrelationID", null);
        message.expectAndReturn("getJMSDeliveryMode", (Object)1);
        message.expectAndReturn("getJMSDestination", null);
        message.expectAndReturn("getJMSExpiration", (Object)0L);
        message.expectAndReturn("getJMSMessageID", (Object)"1234567890");
        message.expectAndReturn("getJMSPriority", (Object)4);
        message.expectAndReturn("getJMSRedelivered", (Object)Boolean.FALSE);
        message.expectAndReturn("getJMSReplyTo", null);
        message.expectAndReturn("getJMSTimestamp", (Object)0L);
        message.expectAndReturn("getJMSType", null);
        message.expectAndReturn("getPropertyNames", (Object)IteratorUtils.asEnumeration((Iterator)IteratorUtils.arrayIterator((Object[])new Object[]{"foo"})));
        message.expectAndReturn("getObjectProperty", (Object)C.eq((Object)"foo"), (Object)"bar");
        message.expectAndReturn("equals", (Object)C.eq((Object)MESSAGE_TEXT), true);
        return message.proxy();
    }

    protected Object getUnsupportedTransportMessage() {
        return "this is an invalid transport message for JmsMuleMessageFactory";
    }

    public void testValidPayload() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        Object payload = this.getValidTransportMessage();
        MuleMessage message = factory.create(payload, this.encoding);
        JmsMuleMessageFactoryTestCase.assertNotNull((Object)message);
        JmsMuleMessageFactoryTestCase.assertEquals((Object)payload, (Object)message.getPayload());
        JmsMuleMessageFactoryTestCase.assertEquals((Object)"bar", (Object)message.getInboundProperty("foo"));
    }
}

