/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.jms.Message;
import junit.framework.Assert;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.message.ExceptionMessage;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.functional.CounterCallback;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.jms.redelivery.MessageRedeliveredException;
import org.mule.util.concurrent.Latch;

public class JmsRedeliveryTestCase
extends FunctionalTestCase {
    private final int timeout = this.getTestTimeoutSecs() * 1000 / 4;
    private static final String DESTINATION = "jms://in";
    private static final int MAX_REDELIVERY = 3;

    protected String getConfigResources() {
        return "jms-redelivery.xml";
    }

    public void testRedelivery() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        while (client.request(DESTINATION, 1000L) != null) {
            this.logger.warn((Object)"Destination jms://in isn't empty, draining it");
        }
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("Bouncer");
        final Latch mrexFired = new Latch();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                if (notification.getException() instanceof MessageRedeliveredException) {
                    mrexFired.countDown();
                    Assert.assertEquals((String)JmsRedeliveryTestCase.DESTINATION, (String)((MessageRedeliveredException)notification.getException()).getEndpoint().getEndpointURI().toString());
                    Assert.assertEquals((int)3, (int)((MessageRedeliveredException)notification.getException()).getMaxRedelivery());
                    Assert.assertTrue((boolean)(((MessageRedeliveredException)notification.getException()).getMuleMessage().getPayload() instanceof Message));
                }
            }
        });
        CounterCallback callback = new CounterCallback(){

            public void eventReceived(MuleEventContext context, Object Component) throws Exception {
                int count = this.incCallbackCount();
                JmsRedeliveryTestCase.this.logger.info((Object)("Message Delivery Count is: " + count));
                throw new FunctionalTestException();
            }
        };
        ftc.setEventCallback((EventCallback)callback);
        client.dispatch(DESTINATION, (Object)"Test Message", null);
        Thread.sleep(2000L);
        mrexFired.await((long)this.timeout, TimeUnit.MILLISECONDS);
        JmsRedeliveryTestCase.assertEquals((String)"MessageRedeliveredException never fired.", (long)0L, (long)mrexFired.getCount());
        JmsRedeliveryTestCase.assertEquals((String)"Wrong number of delivery attempts", (int)4, (int)callback.getCallbackCount());
        MuleMessage dl = client.request("jms://dead.letter", 1000L);
        JmsRedeliveryTestCase.assertNotNull((Object)dl);
        JmsRedeliveryTestCase.assertTrue((boolean)(dl.getPayload() instanceof ExceptionMessage));
        ExceptionMessage em = (ExceptionMessage)dl.getPayload();
        JmsRedeliveryTestCase.assertNotNull((Object)em.getException());
        JmsRedeliveryTestCase.assertTrue((boolean)(em.getException() instanceof MessageRedeliveredException));
    }
}

