/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Properties;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.util.ExceptionUtils;

public abstract class AbstractJmsSingleTransactionSingleServiceTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String JMS_QUEUE_INPUT_CONF_A = "in1";
    public static final String JMS_QUEUE_OUTPUT_CONF_A = "out1";
    public static final String JMS_QUEUE_INPUT_CONF_B = "in2";
    public static final String JMS_QUEUE_OUTPUT_CONF_B = "out2";
    public static final String JMS_QUEUE_INPUT_CONF_C = "in3";
    public static final String JMS_QUEUE_OUTPUT_CONF_C = "out3";
    public static final String JMS_QUEUE_INPUT_CONF_D = "in4";
    public static final String JMS_QUEUE_OUTPUT_CONF_D = "out4";
    public static final String JMS_QUEUE_INPUT_CONF_E = "in5";
    public static final String JMS_QUEUE_OUTPUT_CONF_E = "out5";

    @Before
    protected void doSetUp() throws Exception {
        super.doSetUp();
        muleContext.setExceptionListener((SystemExceptionHandler)new TestExceptionStrategy());
    }

    protected Properties getStartUpProperties() {
        Properties props = super.getStartUpProperties();
        props.put("inbound.destination1", this.getJmsConfig().getInboundEndpoint() + "1");
        props.put("inbound.destination2", this.getJmsConfig().getInboundEndpoint() + "2");
        props.put("inbound.destination3", this.getJmsConfig().getInboundEndpoint() + "3");
        props.put("inbound.destination4", this.getJmsConfig().getInboundEndpoint() + "4");
        props.put("inbound.destination5", this.getJmsConfig().getInboundEndpoint() + "5");
        props.put("outbound.destination1", this.getJmsConfig().getOutboundEndpoint() + "1");
        props.put("outbound.destination2", this.getJmsConfig().getOutboundEndpoint() + "2");
        props.put("outbound.destination3", this.getJmsConfig().getOutboundEndpoint() + "3");
        props.put("outbound.destination4", this.getJmsConfig().getOutboundEndpoint() + "4");
        props.put("outbound.destination5", this.getJmsConfig().getOutboundEndpoint() + "5");
        return props;
    }

    @Test
    public void testNone() throws Exception {
        this.scenarioCommit.setInputDestinationName(JMS_QUEUE_INPUT_CONF_A);
        this.scenarioRollback.setInputDestinationName(JMS_QUEUE_INPUT_CONF_A);
        this.scenarioNotReceive.setInputDestinationName(JMS_QUEUE_INPUT_CONF_A);
        this.scenarioCommit.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_A);
        this.scenarioRollback.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_A);
        this.scenarioNotReceive.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_A);
        this.runTransactionPass();
    }

    @Test
    public void testAlwaysBegin() throws Exception {
        this.scenarioCommit.setInputDestinationName(JMS_QUEUE_INPUT_CONF_B);
        this.scenarioRollback.setInputDestinationName(JMS_QUEUE_INPUT_CONF_B);
        this.scenarioNotReceive.setInputDestinationName(JMS_QUEUE_INPUT_CONF_B);
        this.scenarioCommit.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_B);
        this.scenarioRollback.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_B);
        this.scenarioNotReceive.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_B);
        this.runTransactionPass();
    }

    @Test
    public void testBeginOrJoin() throws Exception {
        this.scenarioCommit.setInputDestinationName(JMS_QUEUE_INPUT_CONF_C);
        this.scenarioRollback.setInputDestinationName(JMS_QUEUE_INPUT_CONF_C);
        this.scenarioNotReceive.setInputDestinationName(JMS_QUEUE_INPUT_CONF_C);
        this.scenarioCommit.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_C);
        this.scenarioRollback.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_C);
        this.scenarioNotReceive.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_C);
        this.runTransactionPass();
    }

    @Test
    public void testAlwaysJoin() throws Exception {
        this.scenarioCommit.setInputDestinationName(JMS_QUEUE_INPUT_CONF_D);
        this.scenarioRollback.setInputDestinationName(JMS_QUEUE_INPUT_CONF_D);
        this.scenarioNotReceive.setInputDestinationName(JMS_QUEUE_INPUT_CONF_D);
        this.scenarioCommit.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_D);
        this.scenarioRollback.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_D);
        this.scenarioNotReceive.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_D);
        this.runTransactionPass();
    }

    @Test
    public void testJoinIfPossible() throws Exception {
        this.scenarioCommit.setInputDestinationName(JMS_QUEUE_INPUT_CONF_E);
        this.scenarioRollback.setInputDestinationName(JMS_QUEUE_INPUT_CONF_E);
        this.scenarioNotReceive.setInputDestinationName(JMS_QUEUE_INPUT_CONF_E);
        this.scenarioCommit.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_E);
        this.scenarioRollback.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_E);
        this.scenarioNotReceive.setOutputDestinationName(JMS_QUEUE_OUTPUT_CONF_E);
        this.runTransactionPass();
    }

    protected void runTransactionFail(String serviceName) throws Exception {
        final CountDownLatch exceptionLatch = new CountDownLatch(1);
        this.send(this.scenarioCommit);
        TestExceptionStrategy.ExceptionCallback exceptionCallback = new TestExceptionStrategy.ExceptionCallback(){

            public void onException(Throwable t) {
                Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)t, IllegalTransactionStateException.class));
                Assert.assertEquals((long)1L, (long)exceptionLatch.getCount());
                exceptionLatch.countDown();
            }
        };
        TestExceptionStrategy exceptionStrategy = (TestExceptionStrategy)muleContext.getRegistry().lookupService(serviceName).getExceptionListener();
        exceptionStrategy.setExceptionCallback(exceptionCallback);
        TestExceptionStrategy globalExceptionStrategy = (TestExceptionStrategy)muleContext.getExceptionListener();
        globalExceptionStrategy.setExceptionCallback(exceptionCallback);
        AbstractJmsSingleTransactionSingleServiceTestCase.assertTrue((boolean)exceptionLatch.await(10L, TimeUnit.SECONDS));
        this.receive(this.scenarioNotReceive);
    }

    protected void runTransactionPass() throws Exception {
        this.send(this.scenarioCommit);
        this.receive(this.scenarioRollback);
        this.receive(this.scenarioCommit);
        this.receive(this.scenarioNotReceive);
    }
}

