/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsConnectorJndiTestCase
extends AbstractJmsFunctionalTestCase {
    protected String getConfigResources() {
        return "integration/jms-jndi-config.xml";
    }

    @Test
    public void testConnectionFactoryFromJndi() throws Exception {
    }

    @Test
    public void testQueueFromJndi() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("ep_jndi-queue", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        JmsConnectorJndiTestCase.assertNotNull((Object)result);
        JmsConnectorJndiTestCase.assertEquals((String)"INPUT MESSAGE", (String)result.getPayloadAsString());
    }

    @Test
    public void testTopicFromJndi() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("ep_jndi-topic", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        JmsConnectorJndiTestCase.assertNotNull((Object)result);
        JmsConnectorJndiTestCase.assertEquals((String)"INPUT MESSAGE", (String)result.getPayloadAsString());
    }

    @Test
    public void testNonJndiDestination() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("ep_non-jndi-queue", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        JmsConnectorJndiTestCase.assertNotNull((Object)result);
        JmsConnectorJndiTestCase.assertEquals((String)"INPUT MESSAGE", (String)result.getPayloadAsString());
    }

    @Test
    public void testNonJndiDestinationOptional() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("ep_non-jndi-queue-optional-jndi", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        JmsConnectorJndiTestCase.assertNotNull((Object)result);
        JmsConnectorJndiTestCase.assertEquals((String)"INPUT MESSAGE", (String)result.getPayloadAsString());
    }

    @Test
    public void testNonJndiDestinationForce() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("ep_non-jndi-queue-force-jndi", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        JmsConnectorJndiTestCase.assertNull((String)"Attempt to look up a non-existant JNDI Destination should have failed", (Object)result);
    }
}

