/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.Message;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.NullPayload;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.util.StringUtils;

public class JmsSynchronousResponseTestCase
extends AbstractJmsFunctionalTestCase {
    protected String getConfigResources() {
        return "integration/jms-synchronous-response.xml";
    }

    @Test
    public void testResponseWithoutReplyTo() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("out1", (Object)"TEST_MESSAGE", null);
        JmsSynchronousResponseTestCase.assertNotNull((Object)response);
        JmsSynchronousResponseTestCase.assertTrue((String)"Response is not a JMS Message", (boolean)(response.getPayload() instanceof Message));
        this.assertJmsMessageIdPresent(response);
    }

    @Test
    public void testResponseWithoutReplyToEndpointProperties() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("out2", (Object)"TEST_MESSAGE", null);
        JmsSynchronousResponseTestCase.assertNotNull((Object)response);
        JmsSynchronousResponseTestCase.assertTrue((String)"Response is not a JMS Message", (boolean)(response.getPayload() instanceof Message));
        this.assertJmsMessageIdPresent(response);
    }

    @Test
    public void testResponseWithReplyTo() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("out3", (Object)"TEST_MESSAGE", null);
        JmsSynchronousResponseTestCase.assertNotNull((Object)response);
        JmsSynchronousResponseTestCase.assertTrue((String)"Response should be NullPayload", (boolean)(response.getPayload() instanceof NullPayload));
    }

    private void assertJmsMessageIdPresent(MuleMessage message) {
        String messageId = (String)message.getInboundProperty("JMSMessageID");
        JmsSynchronousResponseTestCase.assertTrue((String)"JMSMessageID is missing", (boolean)StringUtils.isNotBlank((String)messageId));
    }
}

