/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.jms.Message;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.source.MessageSource;
import org.mule.construct.Flow;
import org.mule.context.notification.ExceptionNotification;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.functional.CounterCallback;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.transport.jms.redelivery.MessageRedeliveredException;
import org.mule.util.concurrent.Latch;

public class JmsRedeliveryTestCase
extends AbstractServiceAndFlowTestCase {
    private final int timeout = this.getTestTimeoutSecs() * 1000 / 4;
    private static final String DESTINATION = "jms://in";
    private static final int MAX_REDELIVERY = 3;

    public JmsRedeliveryTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "jms-redelivery-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jms-redelivery-flow.xml"});
    }

    @Test
    public void testRedelivery() throws Exception {
        MessageSource source = null;
        Object flowOrService = muleContext.getRegistry().lookupObject("TestSelector");
        Assert.assertNotNull((Object)flowOrService);
        if (flowOrService instanceof Service) {
            Service svc = (Service)flowOrService;
            source = svc.getMessageSource();
        } else {
            Flow flow = (Flow)flowOrService;
            source = flow.getMessageSource();
        }
        InboundEndpoint ep = null;
        if (source instanceof InboundEndpoint) {
            ep = (InboundEndpoint)source;
        } else if (source instanceof ServiceCompositeMessageSource) {
            ep = (InboundEndpoint)((ServiceCompositeMessageSource)source).getEndpoints().get(0);
        }
        Assert.assertNotNull((Object)ep);
        JmsConnector cnctr = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        Assert.assertTrue((boolean)(cnctr.getSelector((ImmutableEndpoint)ep) instanceof JmsSelectorFilter));
        LocalMuleClient client = muleContext.getClient();
        while (client.request(DESTINATION, 1000L) != null) {
            this.logger.warn((Object)"Destination jms://in isn't empty, draining it");
        }
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("Bouncer");
        final Latch messageRedeliveryExceptionFired = new Latch();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                JmsRedeliveryTestCase.this.logger.debug((Object)("onNotification() = " + notification.getException().getClass().getName()));
                if (notification.getException() instanceof MessageRedeliveredException) {
                    messageRedeliveryExceptionFired.countDown();
                    Assert.assertEquals((Object)JmsRedeliveryTestCase.DESTINATION, (Object)((MessageRedeliveredException)notification.getException()).getEndpoint().getEndpointURI().toString());
                    Assert.assertEquals((long)3L, (long)((MessageRedeliveredException)notification.getException()).getMaxRedelivery());
                    Assert.assertTrue((boolean)(((MessageRedeliveredException)notification.getException()).getMuleMessage().getPayload() instanceof Message));
                }
            }
        });
        CounterCallback callback = new CounterCallback(){

            public void eventReceived(MuleEventContext context, Object Component) throws Exception {
                int count = this.incCallbackCount();
                JmsRedeliveryTestCase.this.logger.info((Object)("Message Delivery Count is: " + count));
                throw new FunctionalTestException();
            }
        };
        ftc.setEventCallback((EventCallback)callback);
        client.dispatch(DESTINATION, (Object)"Test Message", null);
        Thread.sleep(2000L);
        if (!messageRedeliveryExceptionFired.await((long)this.timeout, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Exception from FunctionalTestComponent was not triggered three times");
        }
        Assert.assertEquals((String)"MessageRedeliveredException never fired.", (long)0L, (long)messageRedeliveryExceptionFired.getCount());
        Assert.assertEquals((String)"Wrong number of delivery attempts", (long)4L, (long)callback.getCallbackCount());
    }
}

