/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.config;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.filter.Filter;
import org.mule.construct.Flow;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.transaction.XaTransactionFactory;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.filters.JmsPropertyFilter;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.transport.jms.test.TestConnectionFactory;
import org.mule.transport.jms.test.TestRedeliveryHandler;
import org.mule.transport.jms.test.TestRedeliveryHandlerFactory;

public class JmsNamespaceHandlerTestCase
extends AbstractServiceAndFlowTestCase {
    public JmsNamespaceHandlerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setStartContext(false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "jms-namespace-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jms-namespace-config-flow.xml"});
    }

    @Test
    public void testDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnectorDefaults");
        Assert.assertNotNull((Object)c);
        Assert.assertNotNull((Object)c.getConnectionFactory());
        Assert.assertTrue((boolean)(c.getConnectionFactory() instanceof TestConnectionFactory));
        Assert.assertEquals((long)1L, (long)c.getAcknowledgementMode());
        Assert.assertNull((Object)c.getUsername());
        Assert.assertNull((Object)c.getPassword());
        Assert.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        Assert.assertTrue((boolean)(c.getRedeliveryHandlerFactory() instanceof TestRedeliveryHandlerFactory));
        Assert.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof TestRedeliveryHandler));
        Assert.assertNull((Object)c.getClientId());
        Assert.assertFalse((boolean)c.isDurable());
        Assert.assertFalse((boolean)c.isNoLocal());
        Assert.assertFalse((boolean)c.isPersistentDelivery());
        Assert.assertEquals((long)0L, (long)c.getMaxRedelivery());
        Assert.assertFalse((boolean)c.isCacheJmsSessions());
        Assert.assertTrue((boolean)c.isEagerConsumer());
        Assert.assertEquals((long)4L, (long)c.getNumberOfConcurrentTransactedReceivers());
        Assert.assertFalse((boolean)c.isEmbeddedMode());
    }

    @Test
    public void testConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector1");
        Assert.assertNotNull((Object)c);
        Assert.assertNotNull((Object)c.getConnectionFactory());
        Assert.assertTrue((boolean)(c.getConnectionFactory() instanceof TestConnectionFactory));
        Assert.assertEquals((long)3L, (long)c.getAcknowledgementMode());
        Assert.assertEquals((Object)"myuser", (Object)c.getUsername());
        Assert.assertEquals((Object)"mypass", (Object)c.getPassword());
        Assert.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        Assert.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof TestRedeliveryHandler));
        Assert.assertEquals((Object)"myClient", (Object)c.getClientId());
        Assert.assertTrue((boolean)c.isDurable());
        Assert.assertTrue((boolean)c.isNoLocal());
        Assert.assertTrue((boolean)c.isPersistentDelivery());
        Assert.assertEquals((long)5L, (long)c.getMaxRedelivery());
        Assert.assertTrue((boolean)c.isCacheJmsSessions());
        Assert.assertFalse((boolean)c.isEagerConsumer());
        Assert.assertEquals((Object)"1.1", (Object)c.getSpecification());
        Assert.assertEquals((long)7L, (long)c.getNumberOfConcurrentTransactedReceivers());
        Assert.assertTrue((boolean)c.isEmbeddedMode());
    }

    @Test
    public void testCustomConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector2");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)"1.1", (Object)c.getSpecification());
    }

    @Test
    public void testTestConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector3");
        Assert.assertNotNull((Object)c);
        Assert.assertNotNull((Object)c.getConnectionFactory());
        Assert.assertTrue((boolean)(c.getConnectionFactory() instanceof TestConnectionFactory));
        Assert.assertEquals((long)3L, (long)c.getAcknowledgementMode());
        Assert.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        Assert.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof TestRedeliveryHandler));
        Assert.assertEquals((Object)"myClient", (Object)c.getClientId());
        Assert.assertTrue((boolean)c.isDurable());
        Assert.assertTrue((boolean)c.isNoLocal());
        Assert.assertTrue((boolean)c.isPersistentDelivery());
        Assert.assertEquals((long)5L, (long)c.getMaxRedelivery());
        Assert.assertTrue((boolean)c.isCacheJmsSessions());
        Assert.assertFalse((boolean)c.isEagerConsumer());
        Assert.assertEquals((Object)"1.1", (Object)c.getSpecification());
    }

    @Test
    public void testEndpointConfig() throws MuleException {
        InboundEndpoint endpoint1 = muleContext.getRegistry().lookupEndpointBuilder("endpoint1").buildInboundEndpoint();
        Assert.assertNotNull((Object)endpoint1);
        Filter filter1 = endpoint1.getFilter();
        Assert.assertNotNull((Object)filter1);
        Assert.assertTrue((boolean)(filter1 instanceof JmsSelectorFilter));
        Assert.assertEquals((long)1L, (long)endpoint1.getProperties().size());
        Assert.assertEquals((Object)"true", (Object)endpoint1.getProperty((Object)"disableTemporaryReplyToDestinations"));
        OutboundEndpoint endpoint2 = muleContext.getRegistry().lookupEndpointBuilder("endpoint2").buildOutboundEndpoint();
        Assert.assertNotNull((Object)endpoint2);
        Filter filter2 = endpoint2.getFilter();
        Assert.assertNotNull((Object)filter2);
        Assert.assertTrue((boolean)(filter2 instanceof NotFilter));
        Filter filter3 = ((NotFilter)filter2).getFilter();
        Assert.assertNotNull((Object)filter3);
        Assert.assertTrue((boolean)(filter3 instanceof JmsPropertyFilter));
        InboundEndpoint inboundEndpoint = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? (InboundEndpoint)((Flow)muleContext.getRegistry().lookupObject("testService")).getMessageSource() : (InboundEndpoint)((ServiceCompositeMessageSource)muleContext.getRegistry().lookupService("testService").getMessageSource()).getEndpoints().get(0);
        Assert.assertNotNull((Object)inboundEndpoint);
        Assert.assertEquals((long)1L, (long)inboundEndpoint.getProperties().size());
        Assert.assertEquals((Object)"testCustomDurableName", (Object)inboundEndpoint.getProperty((Object)"durableName"));
    }

    @Test
    public void testCustomTransactions() throws EndpointException, InitialisationException {
        InboundEndpoint endpoint3 = muleContext.getRegistry().lookupEndpointBuilder("endpoint3").buildInboundEndpoint();
        Assert.assertNotNull((Object)endpoint3);
        TestTransactionFactory factory = (TestTransactionFactory)endpoint3.getTransactionConfig().getFactory();
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals((Object)"foo", (Object)factory.getValue());
    }

    @Test
    public void testXaTransactions() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointBuilder("endpoint4").buildInboundEndpoint();
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals(XaTransactionFactory.class, endpoint.getTransactionConfig().getFactory().getClass());
        Assert.assertEquals((long)3L, (long)endpoint.getTransactionConfig().getAction());
    }

    @Test
    public void testJndiConnectorAtributes() throws Exception {
        JmsConnector connector = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsJndiConnector");
        Assert.assertNotNull((Object)connector);
        Assert.assertEquals((Object)"org.mule.transport.jms.test.JmsTestContextFactory", (Object)connector.getJndiInitialFactory());
        Assert.assertEquals((Object)"jndi://test", (Object)connector.getJndiProviderUrl());
        Assert.assertEquals((Object)"jms/connectionFactory", (Object)connector.getConnectionFactoryJndiName());
        Assert.assertEquals((Object)"org.mule.transport.jms.test.TestConnectionFactory", (Object)connector.getConnectionFactory().getClass().getName());
        Assert.assertTrue((boolean)connector.isJndiDestinations());
        Assert.assertTrue((boolean)connector.isForceJndiDestinations());
        Assert.assertEquals((Object)"value", connector.getJndiProviderProperties().get("key"));
        Assert.assertEquals((Object)"customValue", connector.getConnectionFactoryProperties().get("customProperty"));
        Assert.assertEquals((Object)"customValue", (Object)((TestConnectionFactory)connector.getConnectionFactory()).getCustomProperty());
    }

    @Test
    public void testActiveMqConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsActiveMqConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1L, (long)c.getNumberOfConsumers());
        c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsActiveMqConnectorXa");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1L, (long)c.getNumberOfConsumers());
    }
}

