/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsXaTransactionConsumeAllMessagesTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String MESSAGE = "some message";
    public static final int TOTAL_MESSAGES = 50;

    protected String getConfigResources() {
        return "integration/jms-consume-all-messages-tx-xa.xml";
    }

    @Test
    public void testSendSeveralMessagesAndRetrieveThemAll() throws Exception {
        int i;
        MuleClient muleClient = new MuleClient(muleContext);
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("IncomingMessageConsumer");
        final CountDownLatch allMessageReceived = new CountDownLatch(50);
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                allMessageReceived.countDown();
            }
        });
        for (i = 0; i < 50; ++i) {
            muleClient.dispatch("in", (Object)MESSAGE, null);
        }
        allMessageReceived.await(3000L, TimeUnit.MILLISECONDS);
        for (i = 0; i < 50; ++i) {
            MuleMessage muleMessage = muleClient.request("out", 300L);
            Assert.assertThat((Object)muleMessage, (Matcher)IsNull.notNullValue());
        }
    }
}

