/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration.activemq;

import java.util.Collections;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.mule.transport.jms.integration.JmsVendorConfiguration;
import org.mule.transport.jms.integration.activemq.ActiveMQTestReconnectionConnectionFactoryWrapper;

public class ActiveMQJmsConfiguration
implements JmsVendorConfiguration {
    public static final String DEFAULT_BROKER_URL = "vm://localhost?broker.persistent=false&broker.useJmx=false";

    public void initialise(Class callingClass) throws Exception {
    }

    @Override
    public Connection getConnection(boolean topic, boolean xa) throws Exception {
        if (xa) {
            return new ActiveMQXAConnectionFactory(DEFAULT_BROKER_URL).createConnection();
        }
        return new ActiveMQConnectionFactory(DEFAULT_BROKER_URL).createConnection();
    }

    @Override
    public String getInboundEndpoint() {
        return this.getProtocol() + "://" + this.getInboundDestinationName();
    }

    @Override
    public String getOutboundEndpoint() {
        return this.getProtocol() + "://" + this.getOutboundDestinationName();
    }

    @Override
    public String getMiddleEndpoint() {
        return this.getProtocol() + "://" + this.getMiddleDestinationName();
    }

    @Override
    public String getTopicBroadcastEndpoint() {
        return this.getProtocol() + "://topic:" + this.getBroadcastDestinationName();
    }

    @Override
    public String getDeadLetterEndpoint() {
        return this.getProtocol() + "://" + this.getDeadLetterDestinationName();
    }

    @Override
    public String getInboundDestinationName() {
        return "in";
    }

    @Override
    public String getOutboundDestinationName() {
        return "out";
    }

    @Override
    public String getMiddleDestinationName() {
        return "middle";
    }

    @Override
    public String getBroadcastDestinationName() {
        return "broadcast";
    }

    @Override
    public String getDeadLetterDestinationName() {
        return "dlq";
    }

    @Override
    public long getSmallTimeout() {
        return 1000L;
    }

    @Override
    public long getTimeout() {
        return 5000L;
    }

    @Override
    public String getProtocol() {
        return "jms";
    }

    public String getName() {
        return "activemq";
    }

    public Map getProperties() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public ConnectionFactory getTestConnectionFactory() {
        return new ActiveMQTestReconnectionConnectionFactoryWrapper();
    }

    public boolean isEnabled() {
        return true;
    }
}

